/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.WfCastorHashMap;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.JobPusher;
import org.cristalise.kernel.lifecycle.instance.Join;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Activity
extends WfVertex {
    protected Vector<String> mErrors;
    private StateMachine machine;
    protected int state = -1;
    public boolean active = false;
    private boolean loopTested;
    private GTimeStamp mStateDate;
    private String mType;
    private String mTypeName;

    public Activity() {
        this.setProperties(new WfCastorHashMap());
        this.mErrors = new Vector(0, 1);
        this.mStateDate = new GTimeStamp();
        DateUtility.setToNow(this.mStateDate);
    }

    protected String getDefaultSMName() {
        return "Default";
    }

    Next addNext(String idNext) {
        return this.addNext((WfVertex)this.getParent().search(idNext));
    }

    @Override
    public Next addNext(WfVertex vertex) {
        return new Next(this, vertex);
    }

    public StateMachine getStateMachine() throws InvalidDataException {
        if (this.machine == null) {
            String name = (String)this.getProperties().get("StateMachineName");
            Integer version = this.deriveVersionNumber(this.getProperties().get("StateMachineVersion"));
            if (name == null || name.length() == 0) {
                name = this.getDefaultSMName();
                if (version == null) {
                    version = 0;
                }
            }
            try {
                this.machine = LocalObjectLoader.getStateMachine(name, version);
            }
            catch (ObjectNotFoundException ex) {
                Logger.error((Throwable)((Object)ex));
                throw new InvalidDataException("Could not load state machine '" + name + "' v" + version);
            }
        }
        return this.machine;
    }

    public int getState() throws InvalidDataException {
        if (this.state == -1) {
            this.state = this.getStateMachine().getInitialStateCode();
        }
        return this.state;
    }

    public String getStateName() throws InvalidDataException {
        return this.getStateMachine().getState(this.getState()).getName();
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isFinished() throws InvalidDataException {
        return this.getStateMachine().getState(this.getState()).isFinished();
    }

    public String request(AgentPath agent, AgentPath delegate, ItemPath itemPath, int transitionID, String requestData, Object locker) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        Transition transition = this.getStateMachine().getTransition(transitionID);
        String usedRole = transition.getPerformingRole(this, agent);
        Schema schema = null;
        String viewName = null;
        boolean storeOutcome = false;
        if (transition.hasOutcome(this.getProperties())) {
            schema = transition.getSchema(this.getProperties());
            viewName = (String)this.getProperties().get("Viewpoint");
            if (requestData != null && requestData.length() > 0) {
                storeOutcome = true;
            } else if (transition.getOutcome().isRequired()) {
                throw new InvalidDataException("Transition requires outcome data, but none was given");
            }
        }
        State oldState = this.getStateMachine().getState(this.state);
        State newState = this.getStateMachine().traverse(this, transition, agent);
        String outcome = this.runActivityLogic(agent, itemPath, transitionID, requestData, locker);
        this.setState(newState.getId());
        this.getProperties().put("Agent Name", transition.getReservation(this, agent));
        Event newEvent = null;
        try {
            History hist = this.getWf().getHistory(locker);
            newEvent = storeOutcome ? hist.addEvent(agent, delegate, usedRole, this.getName(), this.getPath(), this.getType(), schema, this.getStateMachine(), transitionID, viewName) : hist.addEvent(agent, delegate, usedRole, this.getName(), this.getPath(), this.getType(), this.getStateMachine(), transitionID);
            Logger.msg(7, "Activity::auditEvent() - Event:" + newEvent.getName() + " was added to the AuditTrail");
            if (storeOutcome) {
                Viewpoint currentView;
                Outcome newOutcome = new Outcome((int)newEvent.getID(), outcome, schema);
                Gateway.getStorage().put(itemPath, newOutcome, locker);
                if (viewName != null && !viewName.equals("") && !viewName.equals("last")) {
                    currentView = new Viewpoint(itemPath, schema, viewName, newEvent.getID());
                    Gateway.getStorage().put(itemPath, currentView, locker);
                }
                currentView = new Viewpoint(itemPath, schema, "last", newEvent.getID());
                Gateway.getStorage().put(itemPath, currentView, locker);
            }
            Gateway.getStorage().commit(locker);
        }
        catch (PersistencyException ex) {
            Logger.error((Throwable)((Object)ex));
            Gateway.getStorage().abort(locker);
            throw ex;
        }
        if (newState.isFinished() && (!this.getProperties().get("Breakpoint").equals(Boolean.TRUE) || oldState.isFinished())) {
            this.runNext(agent, itemPath, locker);
        }
        DateUtility.setToNow(this.mStateDate);
        String agentRole = this.getCurrentAgentRole();
        if (agentRole != null && agentRole.length() > 0) {
            try {
                RolePath myRole = Gateway.getLookup().getRolePath(agentRole);
                this.pushJobsToAgents(itemPath, myRole);
            }
            catch (ObjectNotFoundException ex) {
                Logger.msg(7, "Activity.pushJobsToAgents() - Activity role '" + agentRole + " not found.");
            }
        }
        return outcome;
    }

    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, Object locker) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException {
        return requestData;
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        int nbInEdgres = this.getInEdges().length;
        int nbOutEdges = this.getOutEdges().length;
        if (nbInEdgres == 0 && this.getID() != this.getParent().getChildrenGraphModel().getStartVertexId()) {
            this.mErrors.add("Unreachable");
            return false;
        }
        if (nbInEdgres > 1) {
            this.mErrors.add("Bad nb of previous");
            return false;
        }
        if (nbOutEdges > 1) {
            this.mErrors.add("too many next");
            return false;
        }
        if (nbOutEdges == 0 && !((CompositeActivity)this.getParent()).hasGoodNumberOfActivity()) {
            this.mErrors.add("too many endpoints");
            return false;
        }
        return true;
    }

    @Override
    public boolean loop() {
        boolean loop2 = false;
        if (!this.loopTested) {
            this.loopTested = true;
            if (this.getOutGraphables().length != 0) {
                loop2 = ((WfVertex)this.getOutGraphables()[0]).loop();
            }
        }
        this.loopTested = false;
        return loop2;
    }

    @Override
    public void runNext(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        this.setActive(false);
        try {
            Object[] outVertices = this.getOutGraphables();
            Object[] outVertices2 = this.getOutGraphables();
            boolean hasNoNext = false;
            boolean out = false;
            while (!out) {
                if (outVertices2.length > 0) {
                    if (outVertices2[0] instanceof Join) {
                        outVertices2 = ((WfVertex)outVertices2[0]).getOutGraphables();
                        continue;
                    }
                    out = true;
                    continue;
                }
                hasNoNext = true;
                out = true;
            }
            Logger.debug(8, Arrays.toString(outVertices) + " " + Arrays.toString(outVertices2));
            if (!hasNoNext) {
                ((WfVertex)outVertices[0]).run(agent, itemPath, locker);
            } else if (this.getParent() != null && this.getParent().getName().equals("domain")) {
                this.setActive(true);
            } else {
                CompositeActivity parent = (CompositeActivity)this.getParent();
                if (parent != null) {
                    parent.runNext(agent, itemPath, locker);
                }
            }
        }
        catch (InvalidDataException s) {
            this.setActive(true);
            throw s;
        }
    }

    public Next getNext() {
        if (this.getOutEdges().length > 0) {
            return (Next)this.getOutEdges()[0];
        }
        return null;
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        Vertex[] outVertices = this.getOutGraphables();
        this.setState(this.getStateMachine().getInitialState().getId());
        if (outVertices.length > 0 && idLoop != this.getID()) {
            WfVertex nextAct = (WfVertex)outVertices[0];
            nextAct.reinit(idLoop);
        }
    }

    @Override
    public String getErrors() {
        if (this.mErrors.size() == 0) {
            return "No error";
        }
        return this.mErrors.elementAt(0);
    }

    @Override
    public void run(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        boolean finished;
        Logger.debug(8, "Activity::run() path:" + this.getPath() + " state:" + this.getState());
        if (!this.getActive()) {
            this.setActive(true);
        }
        if (finished = this.getStateMachine().getState(this.getState()).isFinished()) {
            this.runNext(agent, itemPath, locker);
        } else {
            DateUtility.setToNow(this.mStateDate);
            this.pushJobsToAgents(itemPath);
        }
    }

    @Override
    public void runFirst(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        Logger.debug(8, this.getPath() + " runfirst");
        this.run(agent, itemPath, locker);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean acti) {
        this.active = acti;
    }

    public String getDescription() {
        if (this.getProperties().containsKey("Description")) {
            return (String)this.getProperties().get("Description");
        }
        return "No description";
    }

    public String getCurrentAgentName() {
        return (String)this.getProperties().get("Agent Name");
    }

    public String getCurrentAgentRole() {
        return (String)this.getProperties().get("Agent Role");
    }

    public ArrayList<Job> calculateJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws InvalidAgentPathException, ObjectNotFoundException, InvalidDataException {
        return this.calculateJobsBase(agent, itemPath, false);
    }

    public ArrayList<Job> calculateAllJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws InvalidAgentPathException, ObjectNotFoundException, InvalidDataException {
        return this.calculateJobsBase(agent, itemPath, true);
    }

    private ArrayList<Job> calculateJobsBase(AgentPath agent, ItemPath itemPath, boolean includeInactive) throws ObjectNotFoundException, InvalidDataException, InvalidAgentPathException {
        Logger.msg(7, "calculateJobs - " + this.getPath());
        ArrayList<Job> jobs = new ArrayList<Job>();
        if ((includeInactive || this.getActive()) && !this.getName().equals("domain")) {
            Map<Transition, String> transitions = this.getStateMachine().getPossibleTransitions(this, agent);
            Logger.msg(7, "Activity.calculateJobs() - Got " + transitions.size() + " transitions.");
            for (Transition transition : transitions.keySet()) {
                Logger.msg(7, "Creating Job object for transition " + transition);
                jobs.add(new Job(this, itemPath, transition, agent, transitions.get(transition)));
            }
        }
        return jobs;
    }

    protected void pushJobsToAgents(ItemPath itemPath) {
        String agentRole = this.getCurrentAgentRole();
        if (agentRole != null && agentRole.length() > 0) {
            this.pushJobsToAgents(itemPath, agentRole);
        }
        try {
            for (Transition trans : this.getStateMachine().getState(this.getState()).getPossibleTransitions().values()) {
                String override = trans.getRoleOverride(this.getProperties());
                if (override == null || override.length() <= 0) continue;
                this.pushJobsToAgents(itemPath, override);
            }
        }
        catch (InvalidDataException e) {
            Logger.error("Activity.pushJobsToAgents() - Problem loading state machine '" + this.getProperties().get("StateMachineName") + "' for Job distribution.");
        }
    }

    private void pushJobsToAgents(ItemPath itemPath, String role) {
        try {
            RolePath myRole = Gateway.getLookup().getRolePath(role);
            this.pushJobsToAgents(itemPath, myRole);
        }
        catch (ObjectNotFoundException ex) {
            Logger.msg(7, "Activity.pushJobsToAgents() - Activity role '" + role + " not found.");
        }
    }

    private void pushJobsToAgents(ItemPath itemPath, RolePath role) {
        if (role.hasJobList()) {
            new JobPusher(this, itemPath, role).start();
        }
        Iterator<Path> childRoles = role.getChildren();
        while (childRoles.hasNext()) {
            RolePath childRole = (RolePath)childRoles.next();
            this.pushJobsToAgents(itemPath, childRole);
        }
    }

    public GTimeStamp getStateDate() {
        return this.mStateDate;
    }

    public void setStateDate(GTimeStamp startDate) {
        this.mStateDate = startDate;
    }

    @Deprecated
    public void setActiveDate(GTimeStamp date) {
    }

    @Deprecated
    public void setStartDate(GTimeStamp date) {
        this.setStateDate(date);
    }

    public String getType() {
        return this.mType;
    }

    public String getTypeName() {
        if (this.mType == null) {
            return null;
        }
        if (this.mTypeName == null) {
            try {
                ItemPath actType = new ItemPath(this.mType);
                Property nameProp = (Property)Gateway.getStorage().get(actType, "Property/Name", null);
                this.mTypeName = nameProp.getValue();
            }
            catch (Exception e) {
                this.mTypeName = this.mType;
            }
        }
        return this.mTypeName;
    }

    public void setType(String type) {
        this.mType = type;
        this.mTypeName = null;
    }

    @Override
    public void abort() {
        this.active = false;
    }
}

