/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.Agent;
import org.cristalise.kernel.entity.AgentHelper;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.omg.CORBA.Object;

final class JobPusher
extends Thread {
    private final Activity activity;
    private final RolePath myRole;
    private final ItemPath itemPath;

    JobPusher(Activity activity, ItemPath itemPath, RolePath role) {
        this.activity = activity;
        this.itemPath = itemPath;
        this.myRole = role;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Agent job pusher for " + this.itemPath + ":" + this.activity.getName() + " to role " + this.myRole);
        try {
            for (AgentPath nextAgent : Gateway.getLookup().getAgents(this.myRole)) {
                Logger.msg(7, "Activity.JobPusher() - Calculating jobs for " + nextAgent);
                try {
                    JobArrayList jobList = new JobArrayList(this.activity.calculateJobs(nextAgent, this.itemPath, false));
                    Logger.msg(7, "Activity.pushJobsToAgents() - User will receive " + jobList.list.size() + " jobs");
                    String stringJobs = Gateway.getMarshaller().marshall(jobList);
                    Object agentIOR = nextAgent.getIOR();
                    Agent thisAgent = AgentHelper.narrow(agentIOR);
                    Logger.msg(7, "Calling agent " + thisAgent.getSystemKey() + " from " + this.activity.getPath());
                    thisAgent.refreshJobList(this.itemPath.getSystemKey(), this.activity.getPath(), stringJobs);
                }
                catch (Exception ex) {
                    Logger.error("Agent " + nextAgent + " of role " + this.myRole + " could not be found to be informed of a change in " + this.itemPath);
                    Logger.error(ex);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            Logger.warning("JobPusher cannot push jobs, it did not find any agents for role:" + this.myRole);
        }
    }
}

