/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Split;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.utils.Logger;

public class OrSplit
extends Split {
    @Override
    public void runNext(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        String[] nextsTab = this.calculateNexts(itemPath, locker);
        int active = 0;
        DirectedEdge[] outEdges = this.getOutEdges();
        for (String thisNext : nextsTab) {
            Logger.msg(7, "Finding next " + thisNext);
            for (DirectedEdge outEdge : outEdges) {
                Next nextEdge = (Next)outEdge;
                if (thisNext == null || !thisNext.equals(nextEdge.getProperties().get("Alias"))) continue;
                WfVertex term = nextEdge.getTerminusVertex();
                try {
                    term.run(agent, itemPath, locker);
                }
                catch (InvalidDataException e) {
                    Logger.error((Throwable)((Object)e));
                    throw new InvalidDataException("Error enabling next " + thisNext);
                }
                Logger.msg(7, "Running " + nextEdge.getProperties().get("Alias"));
                ++active;
            }
        }
        if (active == 0) {
            throw new InvalidDataException("No nexts were activated!");
        }
    }
}

