/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.HashMap;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.routingHelpers.ActivityDataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.PropertyDataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.ViewpointDataHelper;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Parameter;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public abstract class WfVertex
extends GraphableVertex {
    public abstract void runFirst(AgentPath var1, ItemPath var2, Object var3) throws InvalidDataException;

    public WfVertex() {
        this.setIsLayoutable(true);
        this.setIsComposite(false);
    }

    public abstract void runNext(AgentPath var1, ItemPath var2, Object var3) throws InvalidDataException;

    public abstract void reinit(int var1) throws InvalidDataException;

    public void abort() {
    }

    public abstract boolean verify();

    public abstract String getErrors();

    public abstract void run(AgentPath var1, ItemPath var2, Object var3) throws InvalidDataException;

    public abstract boolean loop();

    public abstract Next addNext(WfVertex var1);

    public Object evaluateProperty(ItemPath itemPath, String propName, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        return this.evaluatePropertyValue(itemPath, this.getProperties().get(propName), locker);
    }

    public Object evaluatePropertyValue(ItemPath itemPath, Object propValue, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        DataHelper dataHelper;
        if (!(propValue instanceof String) || !((String)propValue).contains("//")) {
            return propValue;
        }
        String propValString = (String)propValue;
        String[] valueSplit = propValString.split("//");
        if (valueSplit.length != 2) {
            throw new InvalidDataException("Invalid param: " + propValue);
        }
        String pathType = valueSplit[0];
        String dataPath = valueSplit[1];
        String actContext = this.getPath();
        actContext = actContext.substring(0, actContext.lastIndexOf(47));
        try {
            dataHelper = WfVertex.getDataHelper(pathType);
        }
        catch (ObjectNotFoundException ex) {
            return propValue;
        }
        if (itemPath == null) {
            itemPath = this.getWf().getItemPath();
        }
        return dataHelper.get(itemPath, actContext, dataPath, locker);
    }

    public static DataHelper getDataHelper(String id) throws InvalidDataException, ObjectNotFoundException {
        Object configHelper = Gateway.getProperties().getObject("DataHelper." + id);
        if (configHelper != null) {
            if (configHelper instanceof DataHelper) {
                return (DataHelper)configHelper;
            }
            throw new InvalidDataException("Property DataHelper." + id + " was not a DataHelper: " + configHelper.toString());
        }
        switch (id) {
            case "viewpoint": {
                return new ViewpointDataHelper();
            }
            case "property": {
                return new PropertyDataHelper();
            }
            case "activity": {
                return new ActivityDataHelper();
            }
        }
        throw new ObjectNotFoundException("Data helper '" + id + "' unknown");
    }

    protected Object evaluateScript(String scriptName, Integer scriptVersion, ItemPath itemPath, Object locker) throws ScriptingEngineException {
        try {
            Script script = WfVertex.getScript(scriptName, scriptVersion);
            HashMap<String, Parameter> scriptInputParams = script.getAllInputParams();
            for (KeyValuePair vertexProp : this.getProperties().getKeyValuePairs()) {
                if (!scriptInputParams.containsKey(vertexProp.getKey())) continue;
                Object value = vertexProp.getValue();
                Logger.msg(5, "WfVertex.evaluateScript() - Match found for '" + vertexProp.getKey() + "' => setting value from " + value);
                Object inputParam = this.evaluatePropertyValue(itemPath, value, locker);
                Logger.msg(5, "Split.evaluateScript() - Setting param " + vertexProp.getKey() + " to " + inputParam);
                script.setInputParamValue(vertexProp.getKey(), inputParam);
            }
            if (scriptInputParams.containsKey("item")) {
                script.setInputParamValue("item", Gateway.getProxyManager().getProxy(itemPath));
            }
            if (scriptInputParams.containsKey("agent")) {
                AgentPath systemAgent = Gateway.getLookup().getAgentPath("system");
                script.setInputParamValue("agent", Gateway.getProxyManager().getProxy(systemAgent));
            }
            Object retVal = script.execute();
            Logger.msg(2, "Split.evaluateScript() - Script returned " + retVal);
            if (retVal == null) {
                retVal = "";
            }
            return retVal;
        }
        catch (Exception e) {
            Logger.msg(1, "Split.evaluateScript() - Error: Script " + scriptName);
            Logger.error(e);
            throw new ScriptingEngineException(e.getMessage());
        }
    }

    private static Script getScript(String name, Integer version) throws ScriptingEngineException, ObjectNotFoundException, InvalidDataException {
        Script script;
        if (name == null || name.length() == 0) {
            throw new ScriptingEngineException("Script name is empty");
        }
        if (version != null) {
            script = LocalObjectLoader.getScript(name, version);
        } else {
            int split = name.indexOf(":");
            script = new Script(name.substring(0, split), name.substring(split + 1));
        }
        return script;
    }

    public Workflow getWf() {
        return ((CompositeActivity)this.getParent()).getWf();
    }

    public static enum Types {
        Atomic,
        Composite,
        OrSplit,
        XOrSplit,
        AndSplit,
        LoopSplit,
        Join,
        Route;

    }
}

