/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.Logger;

public class AddMemberToCollection
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectNotFoundException, InvalidCollectionModification {
        ItemPath newChild;
        String collName;
        CastorHashMap props = null;
        Object[] params = AddMemberToCollection.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "AddMemberToCollection: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        try {
            collName = params[0];
            try {
                newChild = new ItemPath(params[1]);
            }
            catch (InvalidItemPathException e) {
                newChild = new DomainPath((String)params[1]).getItemPath();
            }
            if (params.length > 2) {
                props = (CastorHashMap)Gateway.getMarshaller().unmarshall((String)params[2]);
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("AddMemberToCollection: Invalid parameters " + Arrays.toString(params));
        }
        C2KLocalObject collObj = Gateway.getStorage().get(item, "Collection/" + collName + "/last", locker);
        if (!(collObj instanceof Dependency)) {
            throw new InvalidDataException("AddMemberToCollection: AddMemberToCollection operates on Dependency collections only.");
        }
        Dependency dep = (Dependency)collObj;
        if (props == null) {
            dep.addMember(newChild);
        } else {
            dep.addMember(newChild, props, dep.getClassProps());
        }
        Gateway.getStorage().put(item, dep, locker);
        return requestData;
    }
}

