/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionManager;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Import
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        int schemaVersion;
        Object[] params = Import.getDataList((String)requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "Import: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        int split1 = params[0].indexOf(95);
        int split2 = params[0].indexOf(58);
        if (split1 == -1) {
            throw new InvalidDataException("Import: Invalid parameters " + Arrays.toString(params));
        }
        requestData = params[1];
        String viewpoint = null;
        String schemaName = ((String)params[0]).substring(0, split1);
        if (split2 > -1) {
            schemaVersion = Integer.parseInt(((String)params[0]).substring(split1 + 1, split2));
            viewpoint = ((String)params[0]).substring(split2 + 1);
        } else {
            schemaVersion = Integer.parseInt(((String)params[0]).substring(split1 + 1));
        }
        Schema schema = LocalObjectLoader.getSchema(schemaName, schemaVersion);
        Object timestamp = params.length == 3 ? params[2] : Event.timeToString(Event.getGMT());
        TransactionManager storage = Gateway.getStorage();
        History hist = this.getWf().getHistory();
        Event event = hist.addEvent(agent, null, this.getCurrentAgentRole(), this.getName(), this.getPath(), this.getType(), schema, this.getStateMachine(), transitionID, viewpoint, (String)timestamp);
        try {
            storage.put(item, new Outcome((int)event.getID(), (String)requestData, schema), locker);
            storage.put(item, new Viewpoint(item, schema, viewpoint, event.getID()), locker);
            if (!"last".equals(viewpoint)) {
                storage.put(item, new Viewpoint(item, schema, "last", event.getID()), locker);
            }
        }
        catch (PersistencyException e) {
            storage.abort(locker);
            throw e;
        }
        storage.commit(locker);
        return requestData;
    }
}

