/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.AgentPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.item.ItemPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.server.ServerPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public abstract class PredefinedStep
extends Activity {
    private boolean isPredefined = false;
    public static final int DONE = 0;
    public static final int AVAILABLE = 0;

    public PredefinedStep() {
        this.getProperties().put("SchemaType", "PredefinedStepOutcome");
        this.getProperties().put("SchemaVersion", "0");
    }

    @Override
    public boolean getActive() {
        if (this.isPredefined) {
            return true;
        }
        return super.getActive();
    }

    @Override
    protected String getDefaultSMName() {
        return "PredefinedStep";
    }

    @Override
    public String getErrors() {
        if (this.isPredefined) {
            return this.getName();
        }
        return super.getErrors();
    }

    @Override
    public boolean verify() {
        if (this.isPredefined) {
            return true;
        }
        return super.verify();
    }

    public boolean getIsPredefined() {
        return this.isPredefined;
    }

    public void setIsPredefined(boolean isPredefined) {
        this.isPredefined = isPredefined;
    }

    @Override
    public String getType() {
        return this.getName();
    }

    public static String getPredefStepSchemaName(String stepName) {
        PredefinedStepContainer[] allSteps;
        for (PredefinedStepContainer thisContainer : allSteps = new PredefinedStepContainer[]{new ItemPredefinedStepContainer(), new AgentPredefinedStepContainer(), new ServerPredefinedStepContainer()}) {
            String stepPath = thisContainer.getName() + "/" + stepName;
            Activity step = (Activity)thisContainer.search(stepPath);
            if (step == null) continue;
            return (String)step.getProperties().get("SchemaType");
        }
        return "PredefinedStepOutcome";
    }

    @Override
    protected abstract String runActivityLogic(AgentPath var1, ItemPath var2, int var3, String var4, Object var5) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException;

    public static String bundleData(String[] data) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document dom = builder.newDocument();
            Element root = dom.createElement("PredefinedStepOutcome");
            dom.appendChild(root);
            for (String element : data) {
                Element param = dom.createElement("param");
                Text t = dom.createTextNode(element);
                param.appendChild(t);
                root.appendChild(param);
            }
            return Outcome.serialize(dom, false);
        }
        catch (Exception e) {
            Logger.error(e);
            StringBuffer xmlData = new StringBuffer().append("<PredefinedStepOutcome>");
            for (String element : data) {
                xmlData.append("<param><![CDATA[").append(element).append("]]></param>");
            }
            xmlData.append("</PredefinedStepOutcome>");
            return xmlData.toString();
        }
    }

    public static String bundleData(String data) {
        return PredefinedStep.bundleData(new String[]{data});
    }

    public static String[] getDataList(String xmlData) {
        try {
            Document scriptDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xmlData)));
            NodeList nodeList = scriptDoc.getElementsByTagName("param");
            String[] result = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i).getFirstChild();
                if (n instanceof CDATASection) {
                    result[i] = ((CDATASection)n).getData();
                    continue;
                }
                if (!(n instanceof Text)) continue;
                result[i] = ((Text)n).getData();
            }
            return result;
        }
        catch (Exception ex) {
            Logger.error("Exception::PredefinedStep::getDataList()");
            Logger.error(ex);
            return null;
        }
    }
}

