/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class RemoveC2KObject
extends PredefinedStep {
    public RemoveC2KObject() {
        this.getProperties().put("Agent Role", "Admin");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, PersistencyException {
        Object[] params = RemoveC2KObject.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "RemoveC2KObject: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        if (params.length != 1) {
            throw new InvalidDataException("RemoveC2KObject: Invalid parameters " + Arrays.toString(params));
        }
        String path = params[0];
        try {
            Gateway.getStorage().remove(item, path, locker);
        }
        catch (PersistencyException ex) {
            throw new PersistencyException("RemoveC2KObject: Error removing object '" + path + "': " + ex.getMessage());
        }
        return requestData;
    }
}

