/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class RemoveDomainPath
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        Object[] params = RemoveDomainPath.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "RemoveDomainPath: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        if (params.length != 1) {
            throw new InvalidDataException("RemoveDomainPath: Invalid parameters " + Arrays.toString(params));
        }
        DomainPath domainPath = new DomainPath(params[0]);
        if (!domainPath.exists()) {
            throw new ObjectNotFoundException("RemoveDomainPath: Domain path " + domainPath.toString() + " does not exist.");
        }
        if (domainPath.getType() != 2) {
            try {
                if (!domainPath.getItemPath().equals(item)) {
                    throw new InvalidDataException("RemoveDomainPath: Domain path " + domainPath.toString() + " is not an alias of the current Item " + item);
                }
            }
            catch (ObjectNotFoundException ex) {
                throw new InvalidDataException("RemoveDomainPath: Domain path " + domainPath.toString() + " is a context.");
            }
        }
        LookupManager lookupManager = Gateway.getLookupManager();
        lookupManager.delete(domainPath);
        return requestData;
    }
}

