/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class ReplaceDomainWorkflow
extends PredefinedStep {
    public ReplaceDomainWorkflow() {
        this.getProperties().put("Agent Role", "Admin");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, PersistencyException {
        CompositeActivity domain;
        Workflow lifeCycle = this.getWf();
        Object[] params = ReplaceDomainWorkflow.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "AddC2KObject: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        if (params.length != 1) {
            throw new InvalidDataException("AddC2KObject: Invalid parameters " + Arrays.toString(params));
        }
        lifeCycle.getChildGraphModel().removeVertex(lifeCycle.search("workflow/domain"));
        try {
            domain = (CompositeActivity)Gateway.getMarshaller().unmarshall((String)params[0]);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("ReplaceDomainWorkflow: Could not unmarshall new workflow: " + e.getMessage());
        }
        domain.setName("domain");
        lifeCycle.initChild(domain, true, new GraphPoint(150, 100));
        if (!domain.active) {
            lifeCycle.run(agent, item, locker);
        } else {
            lifeCycle.refreshJobs(item);
        }
        try {
            Gateway.getStorage().put(item, lifeCycle, locker);
        }
        catch (PersistencyException e) {
            throw new PersistencyException("ReplaceDomainWorkflow: Could not write new workflow to storage: " + e.getMessage());
        }
        return requestData;
    }
}

