/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class WriteViewpoint
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException {
        Event ev;
        int evId;
        Object[] params = WriteViewpoint.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "WriteViewpoint: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        if (params.length != 3) {
            throw new InvalidDataException("WriteViewpoint: Invalid parameters " + Arrays.toString(params));
        }
        String schemaName = params[0];
        String viewName = params[1];
        try {
            evId = Integer.parseInt((String)params[2]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("WriteViewpoint: Parameter 3 (EventId) must be an integer");
        }
        try {
            ev = (Event)Gateway.getStorage().get(item, "AuditTrail/" + evId, locker);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)((Object)e));
            throw new PersistencyException("WriteViewpoint: Could not load event " + evId);
        }
        if (ev.getSchemaName() == null || ev.getSchemaName().length() == 0) {
            throw new InvalidDataException("Event " + evId + " does not reference an Outcome, so cannot be assigned to a Viewpoint.");
        }
        Schema thisSchema = LocalObjectLoader.getSchema(schemaName, ev.getSchemaVersion());
        if (!ev.getSchemaName().equals(thisSchema.getItemID())) {
            throw new InvalidDataException("Event outcome schema is " + ev.getSchemaName() + ", and cannot be used for a " + schemaName + " Viewpoint");
        }
        Viewpoint newView = new Viewpoint(item, thisSchema, viewName, evId);
        try {
            Gateway.getStorage().put(item, newView, locker);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)((Object)e));
            throw new PersistencyException("WriteViewpoint: Could not store new viewpoint");
        }
        return requestData;
    }
}

