/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.item;

import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.CorbaServer;
import org.cristalise.kernel.entity.TraceableEntity;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class CreateItemFromDescription
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        String[] input = CreateItemFromDescription.getDataList(requestData);
        String newName = input[0];
        String domPath = input[1];
        String descVer = input.length > 2 ? input[2] : "last";
        PropertyArrayList initProps = input.length > 3 ? this.getInitProperties(input[3]) : new PropertyArrayList();
        Logger.msg(1, "CreateItemFromDescription - Starting.");
        DomainPath context = new DomainPath(new DomainPath(domPath), newName);
        if (context.exists()) {
            throw new ObjectAlreadyExistsException("The path " + context + " exists already.");
        }
        Logger.msg(6, "CreateItemFromDescription - Requesting new item path");
        ItemPath newItemPath = new ItemPath();
        Logger.msg(3, "CreateItemFromDescription - Creating Item");
        CorbaServer factory = Gateway.getCorbaServer();
        if (factory == null) {
            throw new CannotManageException("This process cannot create new Items");
        }
        TraceableEntity newItem = factory.createItem(newItemPath);
        Gateway.getLookupManager().add(newItemPath);
        Logger.msg(3, "CreateItemFromDescription - Initializing Item");
        try {
            newItem.initialise(agent.getSystemKey(), Gateway.getMarshaller().marshall(this.getNewProperties(itemPath, descVer, initProps, newName, agent, locker)), Gateway.getMarshaller().marshall(this.getNewWorkflow(itemPath, descVer, locker)), Gateway.getMarshaller().marshall(this.getNewCollections(itemPath, descVer, locker)));
        }
        catch (PersistencyException e) {
            throw e;
        }
        catch (Exception e) {
            Gateway.getLookupManager().delete(newItemPath);
            throw new InvalidDataException("CreateItemFromDescription: Problem initializing new Item. See log: " + e.getMessage());
        }
        Logger.msg(3, "CreateItemFromDescription - Creating " + context);
        context.setItemPath(newItemPath);
        Gateway.getLookupManager().add(context);
        return requestData;
    }

    protected PropertyArrayList getInitProperties(String input) throws InvalidDataException {
        try {
            return (PropertyArrayList)Gateway.getMarshaller().unmarshall(input);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Initial property parameter was not a marshalled PropertyArrayList: " + input);
        }
    }

    protected PropertyArrayList getNewProperties(ItemPath itemPath, String descVer, PropertyArrayList initProps, String newName, AgentPath agent, Object locker) throws ObjectNotFoundException, InvalidDataException {
        PropertyDescriptionList pdList = PropertyUtility.getPropertyDescriptionOutcome(itemPath, descVer, locker);
        PropertyArrayList props = pdList.instantiate(initProps);
        boolean foundName = false;
        for (Property prop : props.list) {
            if (!prop.getName().equals("Name")) continue;
            foundName = true;
            prop.setValue(newName);
        }
        if (!foundName) {
            props.list.add(new Property("Name", newName, true));
        }
        props.list.add(new Property("Creator", agent.getAgentName(), false));
        return props;
    }

    protected CompositeActivity getNewWorkflow(ItemPath itemPath, String descVer, Object locker) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        String wfDefName = null;
        Integer wfDefVer = null;
        Collection thisCol = (Collection)Gateway.getStorage().get(itemPath, "Collection/workflow/" + descVer, locker);
        CollectionMember wfMember = (CollectionMember)thisCol.getMembers().list.get(0);
        wfDefName = wfMember.resolveItem().getName();
        Object wfVerObj = wfMember.getProperties().get("Version");
        if (wfVerObj == null || String.valueOf(wfVerObj).length() == 0) {
            throw new InvalidDataException("Workflow version number not set");
        }
        try {
            wfDefVer = Integer.parseInt(wfVerObj.toString());
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid workflow version number: " + wfVerObj.toString());
        }
        if (wfDefName == null) {
            throw new InvalidDataException("No workflow given or defined");
        }
        try {
            CompositeActivityDef wfDef = (CompositeActivityDef)LocalObjectLoader.getActDef(wfDefName, wfDefVer);
            return (CompositeActivity)wfDef.instantiate();
        }
        catch (ClassCastException ex) {
            throw new InvalidDataException("Activity def '" + wfDefName + "' was not Composite");
        }
    }

    protected CollectionArrayList getNewCollections(ItemPath itemPath, String descVer, Object locker) throws ObjectNotFoundException, PersistencyException {
        String[] collNames;
        CollectionArrayList colls = new CollectionArrayList();
        for (String collName : collNames = Gateway.getStorage().getClusterContents(itemPath, "Collection")) {
            Collection thisCol = (Collection)Gateway.getStorage().get(itemPath, "Collection/" + collName + "/" + descVer, locker);
            if (!(thisCol instanceof CollectionDescription)) continue;
            CollectionDescription thisDesc = (CollectionDescription)((Object)thisCol);
            colls.put(thisDesc.newInstance());
        }
        return colls;
    }
}

