/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.stateMachine;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class StateMachine
implements DescriptionObject {
    public String name;
    public Integer version;
    public ItemPath itemPath;
    private ArrayList<State> states = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    private final HashMap<Integer, State> stateCodes = new HashMap();
    private final HashMap<Integer, Transition> transitionCodes = new HashMap();
    State initialState;
    int initialStateCode;
    boolean isCoherent = false;
    private int nextStateId = -1;
    private int nextTransId = -1;

    public StateMachine() {
    }

    public StateMachine(String name, Integer version) {
        this();
        this.name = name;
        this.version = version;
    }

    private int getNextStateId() {
        if (this.nextStateId == -1) {
            for (State s : this.states) {
                if (s.id <= this.nextStateId) continue;
                this.nextStateId = s.id;
            }
            ++this.nextStateId;
        }
        return this.nextStateId++;
    }

    private int getNextTransId() {
        if (this.nextTransId == -1) {
            for (Transition t : this.transitions) {
                if (t.id <= this.nextTransId) continue;
                this.nextTransId = t.id;
            }
            ++this.nextTransId;
        }
        return this.nextTransId++;
    }

    public State createState(String name) {
        State newState = new State(this.getNextStateId(), name);
        this.states.add(newState);
        Logger.msg(5, "StateMachine.createState() - created:" + name + " id:" + newState.id);
        return newState;
    }

    public Transition createTransition(String name) {
        Transition newTrans = new Transition(this.getNextTransId(), name);
        this.transitions.add(newTrans);
        Logger.msg(5, "StateMachine.createTransition() - created:" + name + " id:" + newTrans.id);
        return newTrans;
    }

    public void setStates(ArrayList<State> newStates) {
        this.states = newStates;
        this.validate();
    }

    public void setTransitions(ArrayList<Transition> newTransitions) {
        this.transitions = newTransitions;
        this.validate();
    }

    public boolean validate() {
        this.stateCodes.clear();
        this.transitionCodes.clear();
        this.isCoherent = true;
        for (State state : this.states) {
            Logger.debug(6, "State " + state.id + ": " + state.name);
            this.stateCodes.put(state.getId(), state);
        }
        if (this.stateCodes.containsKey(this.initialStateCode)) {
            this.initialState = this.stateCodes.get(this.initialStateCode);
        } else {
            this.isCoherent = false;
        }
        for (Transition trans : this.transitions) {
            Logger.debug(6, "Transition " + trans.id + ": " + trans.name);
            this.transitionCodes.put(trans.getId(), trans);
            this.isCoherent = this.isCoherent && trans.resolveStates(this.stateCodes);
        }
        return this.isCoherent;
    }

    public ArrayList<State> getStates() {
        return this.states;
    }

    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(State initialState) {
        this.initialState = initialState;
        this.initialStateCode = initialState.getId();
    }

    public int getInitialStateCode() {
        return this.initialStateCode;
    }

    public void setInitialStateCode(int initialStateCode) {
        this.initialStateCode = initialStateCode;
        this.initialState = this.stateCodes.get(initialStateCode);
        if (this.initialState == null) {
            this.isCoherent = false;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setItemPath(ItemPath path) {
        this.itemPath = path;
    }

    @Override
    public String getItemID() {
        return this.itemPath.getUUID().toString();
    }

    public Transition getTransition(int transitionID) {
        return this.transitionCodes.get(transitionID);
    }

    public State getState(int stateID) {
        return this.stateCodes.get(stateID);
    }

    @Override
    public CollectionArrayList makeDescCollections() {
        return new CollectionArrayList();
    }

    public Map<Transition, String> getPossibleTransitions(Activity act, AgentPath agent) throws ObjectNotFoundException, InvalidDataException {
        HashMap<Transition, String> returnList = new HashMap<Transition, String>();
        State currentState = this.getState(act.getState());
        for (Integer transCode : currentState.getPossibleTransitionIds()) {
            Transition possTrans = currentState.getPossibleTransitions().get(transCode);
            try {
                String role = possTrans.getPerformingRole(act, agent);
                returnList.put(possTrans, role);
            }
            catch (AccessRightsException ex) {
                if (!Logger.doLog(5)) continue;
                Logger.msg(5, "Transition '" + possTrans + "' not possible for " + agent.getAgentName() + ": " + ex.getMessage());
            }
        }
        return returnList;
    }

    public State traverse(Activity act, Transition transition, AgentPath agent) throws InvalidTransitionException, AccessRightsException, ObjectNotFoundException, InvalidDataException {
        State currentState = this.getState(act.getState());
        if (transition.originState.equals(currentState)) {
            transition.getPerformingRole(act, agent);
            return transition.targetState;
        }
        throw new InvalidTransitionException("Transition '" + transition.getName() + "' not valid from state '" + currentState.getName() + "'");
    }

    public boolean isCoherent() {
        return this.isCoherent;
    }

    @Override
    public void export(Writer imports, File dir) throws IOException, InvalidDataException {
        String smXML;
        try {
            smXML = Gateway.getMarshaller().marshall(this);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Couldn't marshall state machine " + this.getName());
        }
        FileStringUtility.string2File(new File(new File(dir, "SM"), this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), smXML);
        if (imports != null) {
            imports.write("<Resource name=\"" + this.getName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\" ") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ") + "type=\"SM\">boot/SM/" + this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml</Resource>\n");
        }
    }
}

