/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.stateMachine;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.TransitionOutcome;
import org.cristalise.kernel.lifecycle.instance.stateMachine.TransitionScript;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Transition {
    int id;
    String name;
    int originStateId = -1;
    int targetStateId = -1;
    State originState;
    State targetState;
    String reservation;
    String enabledProp;
    boolean requiresActive = true;
    boolean finishing;
    boolean reinitializes = false;
    String roleOverride;
    TransitionOutcome outcome;
    TransitionScript script;

    public Transition() {
    }

    public Transition(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Transition(int id, String name, int originStateId, int targetStateId) {
        this(id, name);
        this.originStateId = originStateId;
        this.targetStateId = targetStateId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public State getOriginState() {
        return this.originState;
    }

    public void setOriginState(State originState) {
        this.originState = originState;
    }

    public State getTargetState() {
        return this.targetState;
    }

    public void setTargetState(State targetState) {
        this.targetState = targetState;
        this.finishing = targetState.finished;
    }

    public String getEnabledProp() {
        return this.enabledProp;
    }

    public void setEnabledProp(String enabledProp) {
        this.enabledProp = enabledProp;
    }

    public boolean isRequiresActive() {
        return this.requiresActive;
    }

    public boolean isFinishing() {
        return this.finishing;
    }

    public boolean reinitializes() {
        return this.reinitializes;
    }

    public void setReinitializes(boolean reinit) {
        if (this.finishing) {
            throw new RuntimeException("Transition cannot be both reinitializing and finishing");
        }
        this.reinitializes = reinit;
    }

    public void setRequiresActive(boolean requiresActive) {
        this.requiresActive = requiresActive;
    }

    public String getRoleOverride() {
        return this.roleOverride;
    }

    public String getRoleOverride(CastorHashMap actProps) {
        return Transition.resolveValue(this.roleOverride, actProps);
    }

    public void setRoleOverride(String roleOverride) {
        this.roleOverride = roleOverride;
    }

    public TransitionOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(TransitionOutcome outcome) {
        this.outcome = outcome;
    }

    public TransitionScript getScript() {
        return this.script;
    }

    public void setScript(TransitionScript script) {
        this.script = script;
    }

    public String getReservation() {
        return this.reservation;
    }

    public void setReservation(String reservation) {
        this.reservation = reservation;
    }

    protected boolean resolveStates(HashMap<Integer, State> states) {
        boolean allFound = true;
        if (states.keySet().contains(this.originStateId)) {
            this.setOriginState(states.get(this.originStateId));
            this.originState.addPossibleTransition(this);
        } else {
            allFound = false;
        }
        if (states.keySet().contains(this.targetStateId)) {
            this.setTargetState(states.get(this.targetStateId));
        } else {
            allFound = false;
        }
        return allFound;
    }

    public int getOriginStateId() {
        return this.originStateId;
    }

    public void setOriginStateId(int originStateId) {
        this.originStateId = originStateId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTargetStateId() {
        return this.targetStateId;
    }

    public void setTargetStateId(int targetStateId) {
        this.targetStateId = targetStateId;
    }

    public String getPerformingRole(Activity act, AgentPath agent) throws ObjectNotFoundException, AccessRightsException {
        if (!this.isEnabled(act)) {
            throw new AccessRightsException("Transition '" + this.name + "' is disabled by the '" + this.enabledProp + "' property.");
        }
        if (this.isRequiresActive() && !act.getActive()) {
            throw new AccessRightsException("Activity must be active to perform this transition");
        }
        RolePath role = null;
        String overridingRole = this.getRoleOverride(act.getProperties());
        boolean override = overridingRole != null;
        boolean isOwner = false;
        boolean isOwned = true;
        String agentName = act.getCurrentAgentName();
        if (agentName != null && agentName.length() > 0) {
            if (agent.getAgentName().equals(agentName)) {
                isOwner = true;
            }
        } else {
            isOwned = false;
        }
        if (override) {
            role = Gateway.getLookup().getRolePath(overridingRole);
        } else {
            String actRole = act.getCurrentAgentRole();
            if (actRole != null && actRole.length() > 0) {
                role = Gateway.getLookup().getRolePath(actRole);
            }
        }
        if (isOwned && !override && !isOwner) {
            throw new AccessRightsException("Agent '" + agent.getAgentName() + "' cannot perform this transition because the activity '" + act.getName() + "' is currently owned by " + agentName);
        }
        if (role != null) {
            if (agent.hasRole(role)) {
                return role.getName();
            }
            if (agent.hasRole("Admin")) {
                return "Admin";
            }
            throw new AccessRightsException("Agent '" + agent.getAgentName() + "' does not hold a suitable role '" + role.getName() + "' for the activity " + act.getName());
        }
        return null;
    }

    public String getReservation(Activity act, AgentPath agent) {
        if (this.reservation == null || this.reservation.length() == 0) {
            this.reservation = this.targetState.finished ? "clear" : "set";
        }
        String reservedAgent = act.getCurrentAgentName();
        if (this.reservation.equals("set")) {
            reservedAgent = agent.getAgentName();
        } else if (this.reservation.equals("clear")) {
            reservedAgent = "";
        }
        return reservedAgent;
    }

    private static String resolveValue(String key, CastorHashMap props) {
        if (key == null) {
            return null;
        }
        String result = key;
        Pattern propField = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher propMatcher = propField.matcher(result);
        while (propMatcher.find()) {
            String propName = propMatcher.group(1);
            Object propValue = props.get(propName);
            Logger.msg(8, "Replacing Property " + propName + " as " + propValue);
            String propValString = propValue == null ? "" : propValue.toString();
            result = result.replace("${" + propName + "}", propValString);
        }
        return result;
    }

    public boolean isEnabled(Activity act) throws ObjectNotFoundException {
        Object propValue;
        if (this.enabledProp == null) {
            return true;
        }
        try {
            propValue = act.evaluateProperty(null, this.enabledProp, null);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new ObjectNotFoundException(e.getMessage());
        }
        return new Boolean(propValue.toString());
    }

    public boolean hasOutcome(CastorHashMap actProps) {
        if (this.outcome == null || actProps == null) {
            return false;
        }
        String outcomeName = Transition.resolveValue(this.outcome.schemaName, actProps);
        if (outcomeName == null || outcomeName.length() == 0) {
            return false;
        }
        String outcomeVersion = Transition.resolveValue(this.outcome.schemaVersion, actProps);
        return outcomeVersion != null && outcomeVersion.length() != 0;
    }

    public Schema getSchema(CastorHashMap actProps) throws InvalidDataException, ObjectNotFoundException {
        if (this.hasOutcome(actProps)) {
            try {
                return LocalObjectLoader.getSchema(Transition.resolveValue(this.outcome.schemaName, actProps), Integer.parseInt(Transition.resolveValue(this.outcome.schemaVersion, actProps)));
            }
            catch (NumberFormatException ex) {
                throw new InvalidDataException("Bad schema version number: " + this.outcome.schemaVersion + " (" + Transition.resolveValue(this.outcome.schemaVersion, actProps) + ")");
            }
        }
        return null;
    }

    public Script getScript(CastorHashMap actProps) throws ObjectNotFoundException, InvalidDataException {
        if (this.hasScript(actProps)) {
            try {
                return LocalObjectLoader.getScript(Transition.resolveValue(this.script.scriptName, actProps), Integer.parseInt(Transition.resolveValue(this.script.scriptVersion, actProps)));
            }
            catch (NumberFormatException ex) {
                throw new InvalidDataException("Bad schema version number: " + this.outcome.schemaVersion + " (" + Transition.resolveValue(this.outcome.schemaVersion, actProps) + ")");
            }
        }
        return null;
    }

    @Deprecated
    public String getScriptName(CastorHashMap actProps) {
        try {
            return this.getScript(actProps).getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public int getScriptVersion(CastorHashMap actProps) throws InvalidDataException {
        try {
            return this.getScript(actProps).getVersion();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean hasScript(CastorHashMap actProps) {
        if (this.script == null || actProps == null) {
            return false;
        }
        String scriptName = Transition.resolveValue(this.script.scriptName, actProps);
        if (scriptName == null || scriptName.length() == 0) {
            return false;
        }
        String scriptVersion = Transition.resolveValue(this.script.scriptVersion, actProps);
        return scriptVersion != null && scriptVersion.length() != 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transition other = (Transition)obj;
        return this.id == other.id;
    }
}

