/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.routingHelpers;

import javax.xml.xpath.XPathExpressionException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelper;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;

public class ActivityDataHelper
implements DataHelper {
    @Override
    public String get(ItemPath itemPath, String actContext, String dataPath, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        Workflow workflow = (Workflow)Gateway.getStorage().get(itemPath, "LifeCycle", locker);
        String[] paths = dataPath.split(":");
        if (paths.length != 2) {
            throw new InvalidDataException("Invalid path '" + dataPath + "' it must have only one colon (:)");
        }
        String actPath = paths[0];
        String xpath = paths[1];
        if (actPath.startsWith(".")) {
            actPath = actContext + (actContext.endsWith("/") ? "" : "/") + actPath.substring(2);
        }
        GraphableVertex act = workflow.search(actPath);
        String schemaName = act.getProperties().get("SchemaType").toString();
        Integer schemaVersion = Integer.valueOf(act.getProperties().get("SchemaVersion").toString());
        Schema schema = LocalObjectLoader.getSchema(schemaName, schemaVersion);
        String viewName = act.getProperties().get("Viewpoint").toString();
        if (viewName == null || viewName.equals("")) {
            viewName = "last";
        }
        Viewpoint view = (Viewpoint)Gateway.getStorage().get(itemPath, "ViewPoint/" + schema.getName() + "/" + viewName, locker);
        Outcome oc = (Outcome)Gateway.getStorage().get(itemPath, "Outcome/" + schema.getName() + "/" + view.getSchemaVersion() + "/" + view.getEventId(), locker);
        try {
            return oc.getFieldByXPath(xpath);
        }
        catch (XPathExpressionException e) {
            throw new InvalidDataException("Invalid XPath: " + paths[1]);
        }
    }
}

