/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;

public class AgentPath
extends ItemPath {
    private String mAgentName = null;
    private String mPassword = null;

    public AgentPath(SystemKey syskey) throws InvalidAgentPathException, InvalidItemPathException {
        super(syskey);
        try {
            this.findAgentName();
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAgentPathException();
        }
    }

    protected AgentPath(UUID uuid) throws InvalidAgentPathException, InvalidItemPathException {
        super(uuid);
        try {
            this.findAgentName();
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAgentPathException();
        }
    }

    public AgentPath(ItemPath itemPath) throws InvalidAgentPathException {
        super(itemPath.mUUID);
        try {
            this.findAgentName();
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAgentPathException();
        }
    }

    public AgentPath(ItemPath itemPath, String agentName) {
        super(itemPath.mUUID);
        this.mAgentName = agentName;
    }

    public AgentPath(String path) throws InvalidItemPathException {
        super(path);
        try {
            this.findAgentName();
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAgentPathException();
        }
    }

    public void setAgentName(String agentID) {
        this.mAgentName = agentID;
    }

    public String getAgentName() {
        if (this.mAgentName == null) {
            try {
                this.findAgentName();
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
        }
        return this.mAgentName;
    }

    private void findAgentName() throws ObjectNotFoundException {
        this.mAgentName = Gateway.getLookup().getAgentName(this);
    }

    public RolePath[] getRoles() {
        return Gateway.getLookup().getRoles(this);
    }

    public boolean hasRole(RolePath role) {
        return Gateway.getLookup().hasRole(this, role);
    }

    public boolean hasRole(String role) {
        try {
            return this.hasRole(Gateway.getLookup().getRolePath(role));
        }
        catch (ObjectNotFoundException ex) {
            return false;
        }
    }

    public void setPassword(String passwd) {
        this.mPassword = passwd;
    }

    public String getPassword() {
        return this.mPassword;
    }

    @Override
    public String dump() {
        return super.dump() + "\n        agentID=" + this.mAgentName;
    }

    public static AgentPath fromUUIDString(String uuid) throws InvalidAgentPathException {
        try {
            return new AgentPath(new ItemPath(uuid));
        }
        catch (InvalidItemPathException ex) {
            throw new InvalidAgentPathException(ex.getMessage());
        }
    }
}

