/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;

public class DomainPath
extends Path {
    private ItemPath target = null;
    protected static String mTypeRoot;

    public DomainPath() {
        super((short)0);
    }

    public DomainPath(short type) {
        this.mType = type;
    }

    public DomainPath(String[] path) {
        super(path, (short)0);
    }

    public DomainPath(String path) {
        super(path, (short)0);
    }

    public DomainPath(String path, ItemPath entity) {
        super(path, (short)0);
        this.setItemPath(entity);
    }

    public DomainPath(DomainPath parent, String child) {
        super(parent, child);
    }

    @Override
    public String getRoot() {
        return "domain";
    }

    public DomainPath getParent() {
        if (this.mPath.length == 0) {
            return null;
        }
        String[] parentPath = new String[this.mPath.length - 1];
        System.arraycopy(this.mPath, 0, parentPath, 0, parentPath.length);
        return new DomainPath(parentPath);
    }

    public void setItemPath(ItemPath newTarget) {
        if (newTarget == null) {
            this.target = null;
            this.mType = 1;
            return;
        }
        this.target = newTarget;
        this.mType = (short)2;
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        if (this.mType == 0) {
            this.checkType();
        }
        if (this.target == null) {
            throw new ObjectNotFoundException("Path " + this.toString() + " does not resolve to an Item");
        }
        return this.target;
    }

    @Override
    public short getType() {
        if (this.mType == 0) {
            this.checkType();
        }
        return this.mType;
    }

    protected void checkType() {
        try {
            this.setItemPath(Gateway.getLookup().resolvePath(this));
        }
        catch (InvalidItemPathException ex) {
            this.mType = 1;
        }
        catch (ObjectNotFoundException ex) {
            this.mType = 1;
        }
    }

    public String getName() {
        return this.mPath[this.mPath.length - 1];
    }
}

