/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.Path;

public class ItemPath
extends Path {
    public ItemPath() {
        this.setSysKey(UUID.randomUUID());
    }

    public ItemPath(UUID uuid) {
        this.setSysKey(uuid);
    }

    public ItemPath(SystemKey syskey) {
        this.setSysKey(syskey);
    }

    public ItemPath(String[] path) throws InvalidItemPathException {
        super(path, (short)1);
        this.getSysKeyFromPath();
    }

    public ItemPath(String path) throws InvalidItemPathException {
        super(path, (short)1);
        if (path == null) {
            throw new InvalidItemPathException("Path cannot be null");
        }
        this.getSysKeyFromPath();
    }

    private void getSysKeyFromPath() throws InvalidItemPathException {
        if (this.mPath.length == 1) {
            try {
                this.setSysKey(UUID.fromString(this.mPath[0]));
                this.mType = (short)2;
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidItemPathException(this.mPath[0] + " is not a valid UUID");
            }
        } else {
            throw new InvalidItemPathException("Not a valid item path: " + Arrays.toString(this.mPath));
        }
    }

    @Override
    public String getRoot() {
        return "entity";
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        return this;
    }

    public byte[] getOID() {
        if (this.mType == 1) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(this.mSysKey.msb);
        bb.putLong(this.mSysKey.lsb);
        return bb.array();
    }

    protected void setSysKey(UUID uuid) {
        this.mUUID = uuid;
        this.mSysKey = new SystemKey(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        this.setPathFromUUID(this.mUUID.toString());
    }

    protected void setSysKey(SystemKey sysKey) {
        this.mSysKey = sysKey;
        this.mUUID = new UUID(sysKey.msb, sysKey.lsb);
        this.setPathFromUUID(this.mUUID.toString());
    }

    private void setPathFromUUID(String uuid) {
        this.mPath = new String[1];
        this.mPath[0] = uuid;
        this.mType = (short)2;
    }
}

