/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.process.Gateway;
import org.omg.CORBA.Object;

public abstract class Path {
    public static final String delim = "/";
    public static final short UNKNOWN = 0;
    public static final short CONTEXT = 1;
    public static final short ITEM = 2;
    protected String[] mPath = new String[0];
    protected String mStringPath = null;
    protected short mType = 0;
    protected UUID mUUID;
    protected SystemKey mSysKey;
    protected Object mIOR = null;

    public Path() {
    }

    public Path(short type) {
        this.mType = type;
    }

    public Path(String[] path, short type) {
        this.setPath(path);
        this.mType = type;
    }

    public Path(String path, short type) {
        this.setPath(path);
        this.mType = type;
    }

    public Path(Path parent, String child, short type) {
        this.mPath = Arrays.copyOf(parent.getPath(), parent.getPath().length + 1);
        this.mPath[this.mPath.length - 1] = child;
        this.mType = type;
    }

    public Path(Path parent, String child) {
        this(parent, child, 0);
    }

    public void setPath(String[] path) {
        this.mStringPath = null;
        this.mPath = (String[])path.clone();
        this.mUUID = null;
        this.mSysKey = null;
    }

    public void setPath(String path) {
        StringTokenizer tok;
        ArrayList<String> newPath = new ArrayList<String>();
        if (path != null && (tok = new StringTokenizer(path, delim)).hasMoreTokens()) {
            String first = tok.nextToken();
            if (!first.equals(this.getRoot())) {
                newPath.add(first);
            }
            while (tok.hasMoreTokens()) {
                newPath.add(tok.nextToken());
            }
        }
        this.mPath = newPath.toArray(this.mPath);
        this.mStringPath = null;
        this.mUUID = null;
        this.mSysKey = null;
    }

    public void setIOR(Object IOR) {
        this.mIOR = IOR;
        this.mType = IOR == null ? (short)1 : (short)2;
    }

    public void setPath(Path path) {
        this.mStringPath = null;
        this.mPath = (String[])path.getPath().clone();
        this.mUUID = null;
        this.mSysKey = null;
    }

    public abstract String getRoot();

    public String[] getPath() {
        return this.mPath;
    }

    public String getString() {
        if (this.mStringPath == null) {
            StringBuffer stringPathBuffer = new StringBuffer(delim).append(this.getRoot());
            for (String element : this.mPath) {
                stringPathBuffer.append(delim).append(element);
            }
            this.mStringPath = stringPathBuffer.toString();
        }
        return this.mStringPath;
    }

    public boolean exists() {
        if (Gateway.getLookup() == null) {
            return false;
        }
        return Gateway.getLookup().exists(this);
    }

    public Object getIOR() {
        Object newIOR = null;
        if (this.mIOR == null) {
            Lookup myLookup = Gateway.getLookup();
            try {
                String iorString = myLookup.getIOR(this);
                newIOR = Gateway.getORB().string_to_object(iorString);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            this.setIOR(newIOR);
        }
        return this.mIOR;
    }

    public String toString() {
        return this.getString();
    }

    public short getType() {
        return this.mType;
    }

    public SystemKey getSystemKey() {
        return this.mSysKey;
    }

    public UUID getUUID() {
        return this.mUUID;
    }

    public abstract ItemPath getItemPath() throws ObjectNotFoundException;

    public boolean equals(java.lang.Object path) {
        if (path == null) {
            return false;
        }
        return this.toString().equals(path.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String dump() {
        StringBuffer comp = new StringBuffer("Components: { ");
        for (String element : this.mPath) {
            comp.append("'").append(element).append("' ");
        }
        return "Path - dump(): " + comp.toString() + "}\n        string=" + this.toString() + "\n        uuid=" + this.getUUID() + "\n        type=" + this.mType;
    }
}

