/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.Iterator;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;

public class RolePath
extends Path {
    private boolean hasJobList = false;

    public RolePath() {
        super((short)1);
    }

    public RolePath getParent() throws ObjectNotFoundException {
        if (this.mPath.length < 2) {
            return null;
        }
        return Gateway.getLookup().getRolePath(this.mPath[this.mPath.length - 2]);
    }

    public RolePath(RolePath parent, String roleName) {
        super(parent, roleName, (short)1);
    }

    public RolePath(String[] path, boolean jobList) {
        super(path, (short)1);
        this.hasJobList = jobList;
    }

    public RolePath(RolePath parent, String roleName, boolean jobList) {
        this(parent, roleName);
        this.hasJobList = jobList;
    }

    public boolean hasJobList() {
        return this.hasJobList;
    }

    public void setHasJobList(boolean hasJobList) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        this.hasJobList = hasJobList;
    }

    public Iterator<Path> getChildren() {
        return Gateway.getLookup().getChildren(this);
    }

    @Override
    public String dump() {
        StringBuffer comp = new StringBuffer("Components: { ");
        for (String element : this.mPath) {
            comp.append("'").append(element).append("' ");
        }
        return "Path - dump(): " + comp.toString() + "}\n        string=" + this.toString() + "\n        type=" + this.mType + "\n        name=" + this.getName() + "\n        ";
    }

    @Override
    public String getRoot() {
        return "role";
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        return null;
    }

    public String getName() {
        if (this.mPath.length > 0) {
            return this.mPath[this.mPath.length - 1];
        }
        return "role";
    }
}

