/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.utils.Logger;

public abstract class ClusterStorage {
    public static final short NONE = 0;
    public static final short READ = 1;
    public static final short WRITE = 2;
    public static final short READWRITE = 3;
    public static final String ROOT = "";
    public static final String PROPERTY = "Property";
    public static final String COLLECTION = "Collection";
    public static final String LIFECYCLE = "LifeCycle";
    public static final String OUTCOME = "Outcome";
    public static final String HISTORY = "AuditTrail";
    public static final String VIEWPOINT = "ViewPoint";
    public static final String JOB = "Job";
    public static final String[] allClusterTypes = new String[]{"Property", "Collection", "LifeCycle", "Outcome", "AuditTrail", "ViewPoint", "Job"};

    public abstract void open(Authenticator var1) throws PersistencyException;

    public abstract void close() throws PersistencyException;

    public abstract short queryClusterSupport(String var1);

    public abstract String getName();

    public abstract String getId();

    protected static String getClusterType(String path) {
        try {
            if (path == null || path.length() == 0) {
                return ROOT;
            }
            int start = path.charAt(0) == '/' ? 1 : 0;
            int end = path.indexOf(47, start + 1);
            if (end == -1) {
                end = path.length();
            }
            return path.substring(start, end);
        }
        catch (Exception ex) {
            Logger.error(ex);
            return ROOT;
        }
    }

    public static String getPath(C2KLocalObject obj) {
        String root = obj.getClusterType();
        if (root == null) {
            return null;
        }
        if (obj instanceof Outcome) {
            Outcome oc = (Outcome)obj;
            return root + "/" + oc.getSchema().getName() + "/" + oc.getSchema().getVersion() + "/" + oc.getName();
        }
        if (obj instanceof Viewpoint) {
            Viewpoint vp = (Viewpoint)obj;
            return root + "/" + vp.getSchemaName() + "/" + vp.getName();
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            return root + "/" + coll.getName() + "/" + coll.getVersionName();
        }
        return root + "/" + obj.getName();
    }

    public abstract C2KLocalObject get(ItemPath var1, String var2) throws PersistencyException;

    public abstract void put(ItemPath var1, C2KLocalObject var2) throws PersistencyException;

    public abstract void delete(ItemPath var1, String var2) throws PersistencyException;

    public abstract String[] getClusterContents(ItemPath var1, String var2) throws PersistencyException;
}

