/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.TransactionalClusterStorage;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.SoftCache;
import org.cristalise.kernel.utils.WeakCache;

public class ClusterStorageManager {
    HashMap<String, ClusterStorage> allStores = new HashMap();
    String[] clusterPriority = new String[0];
    HashMap<String, ArrayList<ClusterStorage>> clusterWriters = new HashMap();
    HashMap<String, ArrayList<ClusterStorage>> clusterReaders = new HashMap();
    ArrayList<TransactionalClusterStorage> transactionalStores = new ArrayList();
    HashMap<ItemPath, Map<String, C2KLocalObject>> memoryCache = new HashMap();

    public ClusterStorageManager(Authenticator auth) throws PersistencyException {
        ArrayList<ClusterStorage> rootStores;
        Object clusterStorageProp = Gateway.getProperties().getObject("ClusterStorage");
        if (clusterStorageProp == null || clusterStorageProp.equals("")) {
            throw new PersistencyException("ClusterStorageManager.init() - no ClusterStorages defined. No persistency!");
        }
        if (clusterStorageProp instanceof String) {
            rootStores = this.instantiateStores((String)clusterStorageProp);
        } else if (clusterStorageProp instanceof ArrayList) {
            ArrayList propStores = (ArrayList)clusterStorageProp;
            rootStores = new ArrayList();
            this.clusterPriority = new String[propStores.size()];
            for (ClusterStorage thisStore : propStores) {
                if (thisStore instanceof ClusterStorage) {
                    rootStores.add(thisStore);
                    continue;
                }
                throw new PersistencyException("Supplied ClusterStorage " + thisStore.toString() + " was not an instance of ClusterStorage");
            }
        } else {
            throw new PersistencyException("Unknown class of ClusterStorage property: " + clusterStorageProp.getClass().getName());
        }
        int clusterNo = 0;
        for (ClusterStorage newStorage : rootStores) {
            try {
                newStorage.open(auth);
            }
            catch (PersistencyException ex) {
                Logger.error((Throwable)((Object)ex));
                throw new PersistencyException("ClusterStorageManager.init() - Error initialising storage handler " + newStorage.getClass().getName() + ": " + ex.getMessage());
            }
            Logger.msg(5, "ClusterStorageManager.init() - Cluster storage " + newStorage.getClass().getName() + " initialised successfully.");
            this.allStores.put(newStorage.getId(), newStorage);
            this.clusterPriority[clusterNo++] = newStorage.getId();
            if (!(newStorage instanceof TransactionalClusterStorage)) continue;
            this.transactionalStores.add((TransactionalClusterStorage)newStorage);
        }
        this.clusterReaders.put("", rootStores);
    }

    public ArrayList<ClusterStorage> instantiateStores(String allClusters) throws PersistencyException {
        ArrayList<ClusterStorage> rootStores = new ArrayList<ClusterStorage>();
        StringTokenizer tok = new StringTokenizer(allClusters, ",");
        this.clusterPriority = new String[tok.countTokens()];
        while (tok.hasMoreTokens()) {
            ClusterStorage newStorage = null;
            String newStorageClass = tok.nextToken();
            try {
                try {
                    newStorage = (ClusterStorage)Class.forName(newStorageClass).newInstance();
                }
                catch (ClassNotFoundException ex2) {
                    newStorage = (ClusterStorage)Class.forName("org.cristalise.storage." + newStorageClass).newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
                throw new PersistencyException("ClusterStorageManager.init() - The cluster storage handler class " + newStorageClass + " could not be found.");
            }
            catch (InstantiationException ex) {
                throw new PersistencyException("ClusterStorageManager.init() - The cluster storage handler class " + newStorageClass + " could not be instantiated.");
            }
            catch (IllegalAccessException ex) {
                throw new PersistencyException("ClusterStorageManager.init() - The cluster storage handler class " + newStorageClass + " was not allowed to be instantiated.");
            }
            rootStores.add(newStorage);
        }
        return rootStores;
    }

    public void close() {
        for (ClusterStorage thisStorage : this.allStores.values()) {
            try {
                thisStorage.close();
            }
            catch (PersistencyException ex) {
                Logger.error((Throwable)((Object)ex));
            }
        }
    }

    private ArrayList<ClusterStorage> findStorages(String clusterType, boolean forWrite) {
        HashMap<String, ArrayList<ClusterStorage>> cache = forWrite ? this.clusterWriters : this.clusterReaders;
        if (cache.containsKey(clusterType)) {
            return cache.get(clusterType);
        }
        Logger.msg(7, "ClusterStorageManager.findStorages() - finding storage for " + clusterType + " forWrite:" + forWrite);
        ArrayList<ClusterStorage> useableStorages = new ArrayList<ClusterStorage>();
        for (String element : this.clusterPriority) {
            int requiredSupport;
            ClusterStorage thisStorage = this.allStores.get(element);
            int n = requiredSupport = forWrite ? 2 : 1;
            if ((thisStorage.queryClusterSupport(clusterType) & requiredSupport) != requiredSupport) continue;
            Logger.msg(7, "ClusterStorageManager.findStorages() - Got " + thisStorage.getName());
            useableStorages.add(thisStorage);
        }
        cache.put(clusterType, useableStorages);
        return useableStorages;
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        ArrayList<String> contents = new ArrayList<String>();
        Logger.msg(8, "ClusterStorageManager.getClusterContents() - Finding contents of " + path);
        ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
        for (ClusterStorage thisReader : readers) {
            try {
                String[] thisArr = thisReader.getClusterContents(itemPath, path);
                if (thisArr == null) continue;
                for (int j = 0; j < thisArr.length; ++j) {
                    if (contents.contains(thisArr[j])) continue;
                    Logger.msg(9, "ClusterStorageManager.getClusterContents() - " + thisReader.getName() + " reports " + thisArr[j]);
                    contents.add(thisArr[j]);
                }
            }
            catch (PersistencyException e) {
                Logger.msg(5, "ClusterStorageManager.getClusterContents() - reader " + thisReader.getName() + " could not retrieve contents of " + itemPath + "/" + path + ": " + e.getMessage());
            }
        }
        String[] retArr = new String[]{};
        retArr = contents.toArray(retArr);
        return retArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException, ObjectNotFoundException {
        StringTokenizer tok;
        C2KLocalObject result = null;
        Map<String, C2KLocalObject> sysKeyMemCache = null;
        sysKeyMemCache = this.memoryCache.get(itemPath);
        if (sysKeyMemCache != null) {
            Map<String, C2KLocalObject> map = sysKeyMemCache;
            synchronized (map) {
                C2KLocalObject obj = sysKeyMemCache.get(path);
                if (obj != null) {
                    Logger.msg(7, "ClusterStorageManager.get() - found " + itemPath + "/" + path + " in memcache");
                    return obj;
                }
            }
        }
        if (path.startsWith("ViewPoint") && path.endsWith("/data") && (tok = new StringTokenizer(path, "/")).countTokens() == 4) {
            Outcome data = null;
            Viewpoint view = (Viewpoint)this.get(itemPath, path.substring(0, path.lastIndexOf("/")));
            if (view != null) {
                data = view.getOutcome();
            }
            return data;
        }
        if (path.indexOf(47) == -1) {
            if (path.equals("AuditTrail")) {
                result = new History(itemPath, null);
            }
            if (path.equals("Job")) {
                if (itemPath instanceof AgentPath) {
                    result = new JobList((AgentPath)itemPath, null);
                } else {
                    throw new ObjectNotFoundException("ClusterStorageManager.get() - Items do not have job lists");
                }
            }
        }
        if (result == null) {
            ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
            for (ClusterStorage thisReader : readers) {
                try {
                    result = thisReader.get(itemPath, path);
                    Logger.msg(7, "ClusterStorageManager.get() - reading " + path + " from " + thisReader.getName() + " for item " + itemPath);
                    if (result == null) continue;
                    break;
                }
                catch (PersistencyException e) {
                    Logger.msg(7, "ClusterStorageManager.get() - reader " + thisReader.getName() + " could not retrieve " + itemPath + "/" + path + ": " + e.getMessage());
                }
            }
        }
        if (result == null) {
            throw new ObjectNotFoundException("ClusterStorageManager.get() - Path " + path + " not found in " + itemPath);
        }
        if (sysKeyMemCache == null) {
            boolean useWeak = Gateway.getProperties().getBoolean("Storage.useWeakCache", false);
            Logger.msg(7, "ClusterStorageManager.put() - Creating " + (useWeak ? "Weak" : "Strong") + " cache for item " + itemPath);
            sysKeyMemCache = useWeak ? new WeakCache() : new SoftCache(0);
            HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
            synchronized (hashMap) {
                this.memoryCache.put(itemPath, sysKeyMemCache);
            }
        }
        Map<String, C2KLocalObject> map = sysKeyMemCache;
        synchronized (map) {
            sysKeyMemCache.put(path, result);
        }
        return result;
    }

    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        this.put(itemPath, obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ItemPath itemPath, C2KLocalObject obj, Object locker) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache;
        String path = ClusterStorage.getPath(obj);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                Logger.msg(7, "ClusterStorageManager.put() - writing " + path + " to " + thisWriter.getName());
                if (thisWriter instanceof TransactionalClusterStorage && locker != null) {
                    ((TransactionalClusterStorage)thisWriter).put(itemPath, obj, locker);
                    continue;
                }
                thisWriter.put(itemPath, obj);
            }
            catch (PersistencyException e) {
                Logger.error("ClusterStorageManager.put() - writer " + thisWriter.getName() + " could not store " + itemPath + "/" + path + ": " + e.getMessage());
                throw e;
            }
        }
        if (this.memoryCache.containsKey(itemPath)) {
            sysKeyMemCache = this.memoryCache.get(itemPath);
        } else {
            boolean useWeak = Gateway.getProperties().getBoolean("Storage.useWeakCache", false);
            Logger.msg(7, "ClusterStorageManager.put() - Creating " + (useWeak ? "Weak" : "Strong") + " cache for item " + itemPath);
            sysKeyMemCache = useWeak ? new WeakCache() : new SoftCache(0);
            HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
            synchronized (hashMap) {
                this.memoryCache.put(itemPath, sysKeyMemCache);
            }
        }
        Map<String, C2KLocalObject> map = sysKeyMemCache;
        synchronized (map) {
            sysKeyMemCache.put(path, obj);
        }
        if (Logger.doLog(9)) {
            this.dumpCacheContents(9);
        }
        if (Gateway.getProxyServer() != null) {
            Gateway.getProxyServer().sendProxyEvent(new ProxyMessage(itemPath, path, false));
        } else {
            Logger.warning("ClusterStorageManager.put() - ProxyServer is null - Proxies are not notified of this event");
        }
    }

    public void remove(ItemPath itemPath, String path) throws PersistencyException {
        this.remove(itemPath, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                Logger.msg(7, "ClusterStorageManager.delete() - removing " + path + " from " + thisWriter.getName());
                if (thisWriter instanceof TransactionalClusterStorage && locker != null) {
                    ((TransactionalClusterStorage)thisWriter).delete(itemPath, path, locker);
                    continue;
                }
                thisWriter.delete(itemPath, path);
            }
            catch (PersistencyException e) {
                Logger.error("ClusterStorageManager.delete() - writer " + thisWriter.getName() + " could not delete " + itemPath + "/" + path + ": " + e.getMessage());
                throw e;
            }
        }
        if (this.memoryCache.containsKey(itemPath)) {
            Map<String, C2KLocalObject> itemMemCache;
            Map<String, C2KLocalObject> map = itemMemCache = this.memoryCache.get(itemPath);
            synchronized (map) {
                itemMemCache.remove(path);
            }
        }
        if (Gateway.getProxyServer() != null) {
            Gateway.getProxyServer().sendProxyEvent(new ProxyMessage(itemPath, path, true));
        } else {
            Logger.warning("ClusterStorageManager.remove() - ProxyServer is null - Proxies are not notified of this event");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ItemPath itemPath, String path) {
        Logger.msg(7, "CSM.clearCache() - removing " + itemPath + "/" + path);
        if (this.memoryCache.containsKey(itemPath)) {
            Map<String, C2KLocalObject> sysKeyMemCache;
            Map<String, C2KLocalObject> map = sysKeyMemCache = this.memoryCache.get(itemPath);
            synchronized (map) {
                Iterator<String> iter = sysKeyMemCache.keySet().iterator();
                while (iter.hasNext()) {
                    String thisPath = iter.next();
                    if (!thisPath.startsWith(path)) continue;
                    Logger.msg(7, "CSM.clearCache() - removing " + itemPath + "/" + thisPath);
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ItemPath itemPath) {
        Logger.msg(5, "CSM.clearCache() - removing entire cache of " + itemPath);
        if (this.memoryCache.containsKey(itemPath)) {
            HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
            synchronized (hashMap) {
                if (Logger.doLog(6)) {
                    Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(itemPath);
                    int size = sysKeyMemCache.size();
                    Logger.msg(6, "CSM.clearCache() - " + size + " objects to remove.");
                }
                this.memoryCache.remove(itemPath);
            }
        } else {
            Logger.msg(6, "CSM.clearCache() - No objects cached");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            this.memoryCache.clear();
        }
        Logger.msg(5, "CSM.clearCache() - cleared entire cache, " + this.memoryCache.size() + " entities.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCacheContents(int logLevel) {
        if (!Logger.doLog(logLevel)) {
            return;
        }
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            for (ItemPath itemPath : this.memoryCache.keySet()) {
                Logger.msg(logLevel, "Cached Objects of Item " + itemPath);
                Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(itemPath);
                try {
                    Map<String, C2KLocalObject> map = sysKeyMemCache;
                    synchronized (map) {
                        Iterator<String> i$ = sysKeyMemCache.keySet().iterator();
                        while (i$.hasNext()) {
                            String name;
                            String path = name = i$.next();
                            try {
                                Logger.msg(logLevel, "    Path " + path + ": " + sysKeyMemCache.get(path).getClass().getName());
                            }
                            catch (NullPointerException e) {
                                Logger.msg(logLevel, "    Path " + path + ": reaped");
                            }
                        }
                    }
                }
                catch (ConcurrentModificationException ex) {
                    Logger.msg(logLevel, "Cache modified - aborting");
                }
            }
            Logger.msg(logLevel, "Total number of cached entities: " + this.memoryCache.size());
        }
    }

    public void begin(Object locker) {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.begin(locker);
        }
    }

    public void commit(Object locker) throws PersistencyException {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.commit(locker);
        }
    }

    public void abort(Object locker) {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.abort(locker);
        }
    }
}

