/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import java.util.HashMap;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.utils.Logger;

public class TransactionManager {
    HashMap<ItemPath, Object> locks;
    HashMap<Object, ArrayList<TransactionEntry>> pendingTransactions;
    ClusterStorageManager storage;

    public TransactionManager(Authenticator auth) throws PersistencyException {
        this.storage = new ClusterStorageManager(auth);
        this.locks = new HashMap();
        this.pendingTransactions = new HashMap();
    }

    public boolean hasPendingTransactions() {
        return this.pendingTransactions.size() > 0;
    }

    public ClusterStorageManager getDb() {
        return this.storage;
    }

    public void close() {
        if (this.pendingTransactions.size() != 0) {
            Logger.error("There were pending transactions on shutdown. All changes were lost.");
            this.dumpPendingTransactions(0);
        }
        Logger.msg("Transaction Manager: Closing storages");
        this.storage.close();
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        return this.storage.getClusterContents(itemPath, path);
    }

    public C2KLocalObject get(ItemPath itemPath, String path, Object locker) throws PersistencyException, ObjectNotFoundException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if (path.indexOf(47) == -1) {
            if (path.equals("AuditTrail") && locker != null) {
                return new History(itemPath, locker);
            }
            if (path.equals("Job") && locker != null) {
                if (itemPath instanceof AgentPath) {
                    return new JobList((AgentPath)itemPath, locker);
                }
                throw new ObjectNotFoundException("TransactionManager.get() - Items do not have job lists");
            }
        }
        if (this.locks.containsKey(itemPath) && this.locks.get(itemPath).equals(locker)) {
            ArrayList<TransactionEntry> lockerTransaction = this.pendingTransactions.get(locker);
            for (TransactionEntry thisEntry : lockerTransaction) {
                if (!itemPath.equals(thisEntry.itemPath) || !path.equals(thisEntry.path)) continue;
                if (thisEntry.obj == null) {
                    throw new PersistencyException("TransactionManager.get() - Cluster " + path + " has been deleted in " + itemPath + " but not yet committed");
                }
                return thisEntry.obj;
            }
        }
        return this.storage.get(itemPath, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(ItemPath itemPath, C2KLocalObject obj, Object locker) throws PersistencyException {
        ArrayList<Object> lockerTransaction;
        Object tempLocker = null;
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsKey(itemPath)) {
                Object thisLocker = this.locks.get(itemPath);
                if (!thisLocker.equals(locker)) throw new PersistencyException("ClusterStorageManager.get() - Access denied: Object " + itemPath + " has been locked for writing by " + thisLocker);
                lockerTransaction = this.pendingTransactions.get(locker);
            } else if (locker == null) {
                tempLocker = new Object();
                this.locks.put(itemPath, tempLocker);
                lockerTransaction = null;
            } else {
                this.locks.put(itemPath, locker);
                lockerTransaction = new ArrayList();
                this.pendingTransactions.put(locker, lockerTransaction);
            }
        }
        if (tempLocker != null) {
            this.storage.put(itemPath, obj);
            this.locks.remove(itemPath);
            return;
        }
        TransactionEntry newEntry = new TransactionEntry(itemPath, obj);
        if (lockerTransaction.contains(newEntry)) {
            lockerTransaction.remove(newEntry);
        }
        lockerTransaction.add(newEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        ArrayList<Object> lockerTransaction;
        Object tempLocker = null;
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsKey(itemPath)) {
                Object thisLocker = this.locks.get(itemPath);
                if (!thisLocker.equals(locker)) throw new PersistencyException("ClusterStorageManager.get() - Access denied: Object " + itemPath + " has been locked for writing by " + thisLocker);
                lockerTransaction = this.pendingTransactions.get(locker);
            } else if (locker == null) {
                tempLocker = new Object();
                this.locks.put(itemPath, tempLocker);
                lockerTransaction = null;
            } else {
                this.locks.put(itemPath, locker);
                lockerTransaction = new ArrayList();
                this.pendingTransactions.put(locker, lockerTransaction);
            }
        }
        if (tempLocker != null) {
            this.storage.remove(itemPath, path);
            this.locks.remove(itemPath);
            return;
        }
        TransactionEntry newEntry = new TransactionEntry(itemPath, path);
        if (lockerTransaction.contains(newEntry)) {
            lockerTransaction.remove(newEntry);
        }
        lockerTransaction.add(newEntry);
    }

    public void removeCluster(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        String[] children;
        for (String element : children = this.getClusterContents(itemPath, path)) {
            this.removeCluster(itemPath, path + (path.length() > 0 ? "/" : "") + element, locker);
        }
        if (children.length == 0 && path.indexOf("/") > -1) {
            this.remove(itemPath, path, locker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Object locker) {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            ArrayList<TransactionEntry> lockerTransactions = this.pendingTransactions.get(locker);
            HashMap<TransactionEntry, Exception> exceptions = new HashMap<TransactionEntry, Exception>();
            if (lockerTransactions == null) {
                return;
            }
            this.storage.begin(locker);
            for (TransactionEntry thisEntry : lockerTransactions) {
                try {
                    if (thisEntry.obj == null) {
                        this.storage.remove(thisEntry.itemPath, thisEntry.path, locker);
                    } else {
                        this.storage.put(thisEntry.itemPath, thisEntry.obj, locker);
                    }
                    this.locks.remove(thisEntry.itemPath);
                }
                catch (Exception e) {
                    exceptions.put(thisEntry, e);
                }
            }
            this.pendingTransactions.remove(locker);
            if (exceptions.size() > 0) {
                this.storage.abort(locker);
                Logger.error("TransactionManager.commit() - Problems during transaction commit of locker " + locker.toString() + ". Database may be in an inconsistent state.");
                for (TransactionEntry entry : exceptions.keySet()) {
                    Exception ex = (Exception)exceptions.get(entry);
                    Logger.msg(entry.toString());
                    Logger.error(ex);
                }
                this.dumpPendingTransactions(0);
                Logger.die("Database failure");
            }
            try {
                this.storage.commit(locker);
            }
            catch (PersistencyException e) {
                this.storage.abort(locker);
                Logger.die("Transactional database failure");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Object locker) {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsValue(locker)) {
                for (ItemPath thisPath : this.locks.keySet()) {
                    if (!this.locks.get(thisPath).equals(locker)) continue;
                    this.locks.remove(thisPath);
                }
            }
            this.pendingTransactions.remove(locker);
        }
    }

    public void clearCache(ItemPath itemPath, String path) {
        if (itemPath == null) {
            this.storage.clearCache();
        } else if (path == null) {
            this.storage.clearCache(itemPath);
        } else {
            this.storage.clearCache(itemPath, path);
        }
    }

    public void dumpPendingTransactions(int logLevel) {
        Logger.msg(logLevel, "================");
        Logger.msg(logLevel, "Transaction dump");
        Logger.msg(logLevel, "Locked Items:");
        if (this.locks.size() == 0) {
            Logger.msg(logLevel, "  None");
        } else {
            for (ItemPath thisPath : this.locks.keySet()) {
                Object locker = this.locks.get(thisPath);
                Logger.msg(logLevel, "  " + thisPath + " locked by " + locker);
            }
        }
        Logger.msg(logLevel, "Open transactions:");
        if (this.pendingTransactions.size() == 0) {
            Logger.msg(logLevel, "  None");
        } else {
            for (Object thisLocker : this.pendingTransactions.keySet()) {
                Logger.msg(logLevel, "  Transaction owner:" + thisLocker);
                ArrayList<TransactionEntry> entries = this.pendingTransactions.get(thisLocker);
                for (TransactionEntry thisEntry : entries) {
                    Logger.msg(logLevel, "    " + thisEntry.toString());
                }
            }
        }
    }

    static class TransactionEntry {
        public ItemPath itemPath;
        public String path;
        public C2KLocalObject obj;

        public TransactionEntry(ItemPath itemPath, C2KLocalObject obj) {
            this.itemPath = itemPath;
            this.path = ClusterStorage.getPath(obj);
            this.obj = obj;
        }

        public TransactionEntry(ItemPath itemPath, String path) {
            this.itemPath = itemPath;
            this.path = path;
            this.obj = null;
        }

        public String toString() {
            StringBuffer report = new StringBuffer();
            if (this.obj == null) {
                report.append("Delete");
            } else {
                report.append("Put " + this.obj.getClass().getName());
            }
            report.append(" at ").append(this.path).append(" in ").append(this.itemPath);
            return report.toString();
        }

        public int hashCode() {
            return this.itemPath.hashCode() * this.path.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof TransactionEntry) {
                return this.hashCode() == ((TransactionEntry)other).hashCode();
            }
            return false;
        }
    }
}

