/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.persistency.outcome.OutcomeValidator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Outcome
implements C2KLocalObject {
    Integer mID;
    Schema mSchema;
    Document mDOM;
    static DocumentBuilder parser;
    static XPath xpath;

    public Outcome(int id, String xml, Schema schema) throws InvalidDataException {
        this(id, (Document)null, schema);
        try {
            this.mDOM = Outcome.parse(xml);
        }
        catch (IOException | SAXException ex) {
            Logger.error(ex);
            throw new InvalidDataException("XML not valid: " + ex.getMessage());
        }
    }

    public String validate() throws InvalidDataException {
        OutcomeValidator validator = OutcomeValidator.getValidator(this.mSchema);
        return validator.validate(this.mDOM);
    }

    public Outcome(int id, Document dom, Schema schema) {
        this.mID = id;
        this.mDOM = dom;
        this.mSchema = schema;
    }

    public Outcome(String path, String xml) throws PersistencyException, InvalidDataException {
        this(path, (Document)null);
        try {
            this.mDOM = Outcome.parse(xml);
        }
        catch (IOException | SAXException ex) {
            Logger.error(ex);
            throw new InvalidDataException("XML not valid: " + ex.getMessage());
        }
    }

    public Outcome(String path, Document data) throws PersistencyException, InvalidDataException {
        Integer schemaVersion;
        StringTokenizer tok = new StringTokenizer(path, "/");
        if (tok.countTokens() != 3 && !tok.nextToken().equals("Outcome")) {
            throw new PersistencyException("Outcome() - Outcome path must have three components: " + path);
        }
        String schemaName = tok.nextToken();
        String verstring = tok.nextToken();
        String objId = tok.nextToken();
        try {
            schemaVersion = Integer.valueOf(verstring);
        }
        catch (NumberFormatException ex) {
            throw new PersistencyException("Outcome() - Outcome version was an invalid number: " + verstring);
        }
        try {
            this.mSchema = LocalObjectLoader.getSchema(schemaName, schemaVersion);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)((Object)e));
            throw new PersistencyException("Outcome() - problem loading schema " + schemaName + " v" + schemaVersion);
        }
        try {
            this.mID = Integer.valueOf(objId);
        }
        catch (NumberFormatException ex) {
            this.mID = null;
        }
        this.mDOM = data;
    }

    public void setID(Integer ID) {
        this.mID = ID;
    }

    public Integer getID() {
        return this.mID;
    }

    @Override
    public void setName(String name) {
        try {
            this.mID = Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            Logger.error("Invalid id set on Outcome:" + name);
        }
    }

    @Override
    public String getName() {
        return this.mID.toString();
    }

    public void setData(String xml) throws SAXException, IOException {
        this.mDOM = Outcome.parse(xml);
    }

    public void setDOM(Document dom) {
        this.mDOM = dom;
    }

    public String getFieldByXPath(String xpath) throws XPathExpressionException, InvalidDataException {
        Node field = this.getNodeByXPath(xpath);
        if (field == null) {
            throw new InvalidDataException(xpath);
        }
        if (field.getNodeType() == 3 || field.getNodeType() == 4) {
            return field.getNodeValue();
        }
        if (field.getNodeType() == 1) {
            NodeList fieldChildren = field.getChildNodes();
            if (fieldChildren.getLength() == 0) {
                throw new InvalidDataException("No child node for element");
            }
            if (fieldChildren.getLength() == 1) {
                Node child = fieldChildren.item(0);
                if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                    return child.getNodeValue();
                }
                throw new InvalidDataException("Can't get data from child node of type " + child.getNodeName());
            }
            throw new InvalidDataException("Element " + xpath + " has too many children");
        }
        if (field.getNodeType() == 2) {
            return field.getNodeValue();
        }
        throw new InvalidDataException("Don't know what to do with node " + field.getNodeName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFieldByXPath(String xpath, String data) throws XPathExpressionException, InvalidDataException {
        Node field = this.getNodeByXPath(xpath);
        if (field == null) {
            throw new InvalidDataException(xpath);
        }
        if (field.getNodeType() == 1) {
            NodeList fieldChildren = field.getChildNodes();
            if (fieldChildren.getLength() == 0) {
                field.appendChild(this.mDOM.createTextNode(data));
                return;
            } else {
                if (fieldChildren.getLength() != 1) throw new InvalidDataException("Element " + xpath + " has too many children");
                Node child = fieldChildren.item(0);
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        child.setNodeValue(data);
                        return;
                    }
                    default: {
                        throw new InvalidDataException("Can't set child node of type " + child.getNodeName());
                    }
                }
            }
        } else {
            if (field.getNodeType() != 2) throw new InvalidDataException("Don't know what to do with node " + field.getNodeName());
            field.setNodeValue(data);
        }
    }

    public String getData() {
        return Outcome.serialize(this.mDOM, false);
    }

    public Document getDOM() {
        return this.mDOM;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public void setSchema(Schema schema) {
        this.mSchema = schema;
    }

    @Deprecated
    public String getSchemaType() {
        return this.mSchema.getName();
    }

    @Deprecated
    public int getSchemaVersion() {
        return this.mSchema.getVersion();
    }

    @Override
    public String getClusterType() {
        return "Outcome";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(String xml) throws SAXException, IOException {
        DocumentBuilder documentBuilder = parser;
        synchronized (documentBuilder) {
            if (xml != null) {
                return parser.parse(new InputSource(new StringReader(xml)));
            }
            return parser.newDocument();
        }
    }

    public String getField(String name) {
        NodeList elements = this.mDOM.getDocumentElement().getElementsByTagName(name);
        if (elements.getLength() == 1 && elements.item(0).hasChildNodes() && elements.item(0).getFirstChild() instanceof Text) {
            return ((Text)elements.item(0).getFirstChild()).getData();
        }
        return null;
    }

    public NodeList getNodesByXPath(String xpathExpr) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(xpathExpr);
        return (NodeList)expr.evaluate(this.mDOM, XPathConstants.NODESET);
    }

    public Node getNodeByXPath(String xpathExpr) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(xpathExpr);
        return (Node)expr.evaluate(this.mDOM, XPathConstants.NODE);
    }

    public static String serialize(Document doc, boolean prettyPrint) {
        Transformer transformer;
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            Logger.error(ex);
            return "";
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", prettyPrint ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter out = new StringWriter();
        try {
            transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            Logger.error(e);
        }
        return ((Object)out).toString();
    }

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(false);
        try {
            parser = dbf.newDocumentBuilder();
            Logger.msg(7, "DocumentBuilder: " + parser.getClass().getName());
        }
        catch (ParserConfigurationException e) {
            Logger.error(e);
            Logger.die("Cannot function without XML parser");
        }
        XPathFactory xPathFactory = XPathFactory.newInstance();
        xpath = xPathFactory.newXPath();
    }
}

