/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import java.io.StringReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.SchemaValidator;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OutcomeValidator
implements ErrorHandler {
    static SchemaValidator schemaValid = new SchemaValidator();
    Schema schema;
    javax.xml.validation.Schema xmlSchema;
    protected StringBuffer errors = null;

    public static OutcomeValidator getValidator(Outcome o) throws InvalidDataException, ObjectNotFoundException {
        Schema schema = o.getSchema();
        return OutcomeValidator.getValidator(schema);
    }

    public static OutcomeValidator getValidator(Schema schema) throws InvalidDataException {
        if (schema.getName().equals("Schema") && schema.getVersion() == 0) {
            return schemaValid;
        }
        return new OutcomeValidator(schema);
    }

    protected OutcomeValidator() {
        this.errors = new StringBuffer();
    }

    public OutcomeValidator(Schema schema) throws InvalidDataException {
        this.schema = schema;
        if (schema.getName().equals("Schema")) {
            throw new InvalidDataException("Use SchemaValidator to validate schema");
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(this);
        this.errors = new StringBuffer();
        Logger.msg(5, "Parsing " + schema.getName() + " version " + schema.getVersion() + ". " + schema.getSchemaData().length() + " chars");
        try {
            this.xmlSchema = schemaFactory.newSchema(new StreamSource(new StringReader(schema.getSchemaData())));
        }
        catch (SAXException ex) {
            throw new InvalidDataException("Error parsing schema: " + ex.getMessage());
        }
        if (this.errors.length() > 0) {
            throw new InvalidDataException("Schema error: \n" + this.errors.toString());
        }
    }

    public synchronized String validate(String outcome) {
        if (outcome == null) {
            return "Outcome String was null";
        }
        this.errors = new StringBuffer();
        try {
            Validator parser = this.xmlSchema.newValidator();
            parser.setErrorHandler(this);
            parser.validate(new StreamSource(new StringReader(outcome)));
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return this.errors.toString();
    }

    public synchronized String validate(Document outcome) {
        this.errors = new StringBuffer();
        try {
            Validator parser = this.xmlSchema.newValidator();
            parser.setErrorHandler(this);
            parser.validate(new DOMSource(outcome));
        }
        catch (Exception e) {
            return "Couldn't create outcome validator:" + e.getMessage();
        }
        return this.errors.toString();
    }

    private void appendError(String level, Exception ex) {
        this.errors.append(level);
        String message = ex.getMessage();
        if (message == null || message.length() == 0) {
            message = ex.getClass().getName();
        }
        this.errors.append(message);
        this.errors.append("\n");
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.appendError("ERROR: ", ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.appendError("FATAL: ", ex);
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.appendError("WARNING: ", ex);
    }
}

