/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;

public class Viewpoint
implements C2KLocalObject {
    ItemPath itemPath;
    String schemaName;
    String name;
    int schemaVersion;
    int eventId;
    public static final int NONE = -1;

    public Viewpoint() {
        this.eventId = -1;
        this.itemPath = null;
        this.schemaVersion = -1;
        this.schemaName = null;
        this.name = null;
    }

    @Deprecated
    public Viewpoint(ItemPath itemPath, String schemaName, String name, int schemaVersion, int eventId) {
        this.itemPath = itemPath;
        this.schemaName = schemaName;
        this.name = name;
        this.schemaVersion = schemaVersion;
        this.eventId = eventId;
    }

    public Viewpoint(ItemPath itemPath, Schema schema, String name, int eventId) {
        this.itemPath = itemPath;
        this.schemaName = schema.getName();
        this.name = name;
        this.schemaVersion = schema.getVersion();
        this.eventId = eventId;
    }

    public Outcome getOutcome() throws ObjectNotFoundException, PersistencyException {
        if (this.eventId == -1) {
            throw new ObjectNotFoundException("No last eventId defined");
        }
        Outcome retVal = (Outcome)Gateway.getStorage().get(this.itemPath, "Outcome/" + this.schemaName + "/" + this.schemaVersion + "/" + this.eventId, null);
        return retVal;
    }

    @Override
    public String getClusterType() {
        return "ViewPoint";
    }

    public int getEventId() {
        return this.eventId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public Event getEvent() throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (this.eventId == -1) {
            throw new InvalidDataException("No last eventId defined");
        }
        return (Event)Gateway.getStorage().get(this.itemPath, "AuditTrail/" + this.eventId, null);
    }

    public String toString() {
        return this.name;
    }
}

