/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.util.Scanner;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.process.auth.ProxyLogin;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptParsingException;

public class ClientShell
extends StandardClient {
    AgentProxy user;
    Script console;

    public ClientShell(AgentProxy user) throws Exception {
        this.user = user;
        this.console = new Script("javascript", user, System.out);
    }

    public void run() {
        Scanner scan = new Scanner(System.in);
        System.out.print("> ");
        while (scan.hasNextLine()) {
            String command = scan.nextLine();
            try {
                this.console.setScriptData(command);
                Object response = this.console.execute();
                if (response == null) {
                    System.out.println("Ok");
                } else {
                    System.out.println(response);
                }
            }
            catch (ScriptParsingException e) {
                System.err.println("Syntax error: " + e.getMessage());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            System.out.print("> ");
        }
        scan.close();
        ClientShell.shutdown(0);
    }

    public static void main(String[] args) throws Exception {
        Gateway.init(ClientShell.readC2KArgs(args));
        ProxyLogin auth = (ProxyLogin)Gateway.getProperties().getInstance("cli.auth");
        AgentProxy user = auth.authenticate(Gateway.getProperties().getProperty("Name"));
        ClientShell shell = new ClientShell(user);
        shell.run();
    }
}

