/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.utils.Logger;

public class UserCodeProcess
extends StandardClient
implements ProxyObserver<Job>,
Runnable {
    private static final int START = 1;
    private static final int COMPLETE = 2;
    private static final int SUSPEND = 3;
    private static final int RESUME = 4;
    protected AgentProxy agent;
    static boolean active = true;
    ArrayList<String> ignoredPaths = new ArrayList();
    HashMap<String, ErrorInfo> errors = new HashMap();
    final HashMap<String, C2KLocalObject> jobs = new HashMap();

    public UserCodeProcess(String agentName, String agentPass, String resource) {
        for (int i = 1; i < 6; ++i) {
            try {
                Logger.msg("Login attempt " + i + " of 5");
                this.agent = Gateway.connect(agentName, agentPass, resource);
                break;
            }
            catch (Exception ex) {
                Logger.error("Could not log in.");
                Logger.error(ex);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        System.out.println(this.getDesc() + " initialised for " + agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Usercode Process");
        this.agent.subscribe(new MemberSubscription<Job>(this, "Job", true));
        while (active) {
            Object jobKey;
            Job thisJob = null;
            HashMap<String, C2KLocalObject> hashMap = this.jobs;
            synchronized (hashMap) {
                if (this.jobs.size() > 0) {
                    thisJob = UserCodeProcess.getJob(this.jobs, 2);
                    if (thisJob == null) {
                        thisJob = UserCodeProcess.getJob(this.jobs, 1);
                    }
                    if (thisJob == null) {
                        thisJob = UserCodeProcess.getJob(this.jobs, 3);
                    }
                    if (thisJob == null) {
                        thisJob = UserCodeProcess.getJob(this.jobs, 4);
                    }
                    if (thisJob == null) {
                        Logger.error("No supported jobs, but joblist is not empty! Discarding remaining jobs");
                        this.jobs.clear();
                    } else {
                        this.jobs.remove(ClusterStorage.getPath(thisJob));
                    }
                }
            }
            if (thisJob != null) {
                jobKey = thisJob.getItemPath() + ":" + thisJob.getStepPath();
                int transitionId = thisJob.getTransition().getId();
                try {
                    if (transitionId == 1) {
                        Logger.msg(5, "Testing start conditions");
                        boolean start = this.assessStartConditions(thisJob);
                        if (start) {
                            Logger.msg(5, "Attempting to start");
                            this.agent.execute(thisJob);
                        } else {
                            Logger.msg(5, "Start conditions failed " + thisJob.getStepName() + " in " + thisJob.getItemPath());
                        }
                    } else if (transitionId == 2) {
                        Logger.msg(5, "Executing logic");
                        this.runUCLogic(thisJob);
                        if (this.ignoredPaths.contains(jobKey)) {
                            this.ignoredPaths.remove(jobKey);
                        }
                    } else if (transitionId == 3) {
                        if (this.ignoredPaths.contains(jobKey)) {
                            if (this.errors.containsKey(jobKey)) {
                                thisJob.setOutcome(Gateway.getMarshaller().marshall(this.errors.get(jobKey)));
                                this.errors.remove(jobKey);
                            }
                            this.agent.execute(thisJob);
                        }
                    } else if (transitionId == 4 && !this.ignoredPaths.contains(jobKey)) {
                        this.agent.execute(thisJob);
                    }
                }
                catch (ScriptErrorException ex) {
                    this.errors.put((String)jobKey, ex.getErrors());
                    this.ignoredPaths.add((String)jobKey);
                }
                catch (InvalidTransitionException ex) {
                }
                catch (Throwable ex) {
                    Logger.error("Error executing " + thisJob.getTransition().getName() + " job:");
                    Logger.error(ex);
                    ErrorInfo ei = new ErrorInfo();
                    ei.setFatal();
                    ei.addError(ex.getClass().getSimpleName());
                    ei.addError(ex.getMessage());
                    this.errors.put((String)jobKey, ei);
                    this.ignoredPaths.add((String)jobKey);
                }
            }
            try {
                jobKey = this.jobs;
                synchronized (jobKey) {
                    if (this.jobs.size() == 0) {
                        Logger.msg("Sleeping");
                        while (active && this.jobs.size() == 0) {
                            this.jobs.wait(2000L);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        try {
            Gateway.close();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private static Job getJob(HashMap<String, C2KLocalObject> jobs, int transition) {
        for (C2KLocalObject c2kLocalObject : jobs.values()) {
            Job thisJob = (Job)c2kLocalObject;
            if (thisJob.getTransition().getId() != transition) continue;
            Logger.msg(1, "=================================================================");
            Logger.msg(1, "Got " + thisJob.getTransition().getName() + " job for " + thisJob.getStepName() + " in " + thisJob.getItemPath());
            return thisJob;
        }
        return null;
    }

    public boolean assessStartConditions(Job job) {
        return true;
    }

    public void runUCLogic(Job job) throws Exception {
        this.agent.execute(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Job contents) {
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            Logger.msg(7, "Adding " + ClusterStorage.getPath(contents));
            this.jobs.put(ClusterStorage.getPath(contents), contents);
            this.jobs.notify();
        }
    }

    @Override
    public void control(String control, String msg) {
        if ("Error".equals(control)) {
            Logger.error("Error in job subscription: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String id) {
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            Logger.msg(7, "Deleting " + id);
            this.jobs.remove(id);
        }
    }

    public static UserCodeProcess getInstance() throws UnknownHostException {
        return new UserCodeProcess(InetAddress.getLocalHost().getHostName(), "uc", Gateway.getProperties().getString("AuthResource", "Cristal"));
    }

    public static void main(String[] args) {
        int status = 0;
        try {
            Gateway.init(UserCodeProcess.readC2KArgs(args));
            UserCodeProcess proc = UserCodeProcess.getInstance();
            new Thread(proc).start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    UserCodeProcess.shutdown();
                }
            }));
        }
        catch (Exception ex) {
            Logger.error(ex);
            try {
                Gateway.close();
            }
            catch (Exception ex1) {
                Logger.error(ex1);
            }
            status = 1;
            System.exit(status);
        }
    }

    public String getDesc() {
        return "Usercode Process";
    }

    public static void shutdown() {
        active = false;
    }
}

