/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleDescRef;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class ModuleActivity
extends ModuleResource {
    ModuleDescRef script;
    ModuleDescRef schema;
    ModuleDescRef stateMachine;
    ActivityDef actDef;

    public ModuleActivity() {
        this.resourceType = "EA";
    }

    public ModuleActivity(ItemProxy child, Integer version) throws ObjectNotFoundException, InvalidDataException {
        this();
        this.version = version;
        this.script = this.getDescRef(child, "script");
        this.schema = this.getDescRef(child, "schema");
        this.stateMachine = this.getDescRef(child, "statemachine");
    }

    public ModuleDescRef getDescRef(ItemProxy child, String collName) throws ObjectNotFoundException, InvalidDataException {
        Collection<?> coll = child.getCollection(collName, this.version);
        if (coll.size() == 1) {
            throw new InvalidDataException("Too many members in " + collName + " collection in " + this.name);
        }
        CollectionMember collMem = (CollectionMember)coll.getMembers().list.get(0);
        return new ModuleDescRef(null, collMem.getChildUUID(), Integer.valueOf(collMem.getProperties().get("Version").toString()));
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException, InvalidDataException {
        CollectionArrayList colls;
        try {
            this.domainPath = Bootstrap.verifyResource(this.ns, this.name, this.version, this.resourceType, this.itemPath, this.resourceLocation, reset);
            this.itemPath = this.domainPath.getItemPath();
        }
        catch (Exception e) {
            Logger.error(e);
            throw new CannotManageException("Exception verifying module resource " + this.ns + "/" + this.name);
        }
        this.actDef = LocalObjectLoader.getActDef(this.name, this.version);
        this.populateActivityDef();
        try {
            colls = this.actDef.makeDescCollections();
        }
        catch (InvalidDataException e) {
            Logger.error((Throwable)((Object)e));
            throw new CannotManageException("Could not create description collections for " + this.getName() + ".");
        }
        for (Collection coll : colls.list) {
            try {
                Gateway.getStorage().put(this.itemPath, coll, null);
                try {
                    Gateway.getStorage().get(this.itemPath, "Collection/" + coll.getName() + "/last", null);
                }
                catch (ObjectNotFoundException ex) {
                    coll.setVersion(null);
                    Gateway.getStorage().put(this.itemPath, coll, null);
                }
            }
            catch (PersistencyException e) {
                Logger.error((Throwable)((Object)e));
                throw new CannotManageException("Persistency exception storing description collections for " + this.getName() + ".");
            }
        }
        return this.domainPath;
    }

    public void populateActivityDef() throws ObjectNotFoundException, CannotManageException {
        try {
            if (this.schema != null) {
                this.actDef.setSchema(LocalObjectLoader.getSchema(this.schema.id == null ? this.schema.name : this.schema.id, this.schema.version));
            }
        }
        catch (NumberFormatException | InvalidDataException e) {
            Logger.error((Throwable)e);
            throw new CannotManageException("Schema definition in " + this.getName() + " not valid.");
        }
        try {
            if (this.script != null) {
                this.actDef.setScript(LocalObjectLoader.getScript(this.script.id == null ? this.script.name : this.script.id, this.script.version));
            }
        }
        catch (NumberFormatException | InvalidDataException e) {
            Logger.error((Throwable)e);
            throw new CannotManageException("Script definition in " + this.getName() + " not valid.");
        }
        try {
            if (this.stateMachine != null) {
                this.actDef.setStateMachine(LocalObjectLoader.getStateMachine(this.stateMachine.id == null ? this.stateMachine.name : this.stateMachine.id, this.stateMachine.version));
            }
        }
        catch (NumberFormatException | InvalidDataException e) {
            Logger.error((Throwable)e);
            throw new CannotManageException("State Machine definition in " + this.getName() + " not valid.");
        }
    }

    public ModuleDescRef getScript() {
        return this.script;
    }

    public void setScript(ModuleDescRef script) {
        this.script = script;
    }

    public ModuleDescRef getSchema() {
        return this.schema;
    }

    public void setSchema(ModuleDescRef schema) {
        this.schema = schema;
    }

    public ModuleDescRef getStateMachine() {
        return this.stateMachine;
    }

    public void setStateMachine(ModuleDescRef stateMachine) {
        this.stateMachine = stateMachine;
    }
}

