/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.persistency.outcome.OutcomeValidator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.Module;
import org.cristalise.kernel.process.module.ModuleException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class ModuleManager {
    ArrayList<Module> modules = new ArrayList();
    HashMap<String, String> modulesXML = new HashMap();
    Properties props = new Properties();
    AgentProxy user;
    boolean isServer;
    OutcomeValidator moduleValidator;

    public ModuleManager(Enumeration<URL> moduleEnum, boolean isServer) throws ModuleException {
        this.isServer = isServer;
        try {
            Schema moduleSchema = LocalObjectLoader.getSchema("Module", 0);
            this.moduleValidator = new OutcomeValidator(moduleSchema);
        }
        catch (InvalidDataException ex) {
            Logger.error((Throwable)((Object)ex));
            throw new ModuleException("Module Schema is not valid");
        }
        catch (ObjectNotFoundException ex) {
            throw new ModuleException("Could not load Module Schema from kernel resources");
        }
        ArrayList<String> loadedModules = new ArrayList<String>();
        ArrayList<String> moduleNs = new ArrayList<String>();
        while (moduleEnum.hasMoreElements()) {
            URL newModuleURL = moduleEnum.nextElement();
            try {
                String moduleXML = FileStringUtility.url2String(newModuleURL);
                String errors = this.moduleValidator.validate(moduleXML);
                if (errors.length() > 0) {
                    throw new ModuleException("Module XML found at " + newModuleURL + " was not valid: " + errors);
                }
                Module newModule = (Module)Gateway.getMarshaller().unmarshall(moduleXML);
                if (newModule.getResURL() != null && newModule.getResURL().length() > 0) {
                    Gateway.getResource().addModuleBaseURL(newModule.getNamespace(), newModule.getResURL());
                }
                this.modules.add(newModule);
                this.modulesXML.put(newModule.getNamespace(), moduleXML);
                if (loadedModules.contains(newModule.getName())) {
                    throw new ModuleException("Module name clash: " + newModule.getName());
                }
                if (moduleNs.contains(newModule.getNamespace())) {
                    throw new ModuleException("Module namespace clash: " + newModule.getNamespace());
                }
                String reqKernelVer = newModule.getInfo().kernelVersion;
                if (reqKernelVer != null && Gateway.getKernelVersion().compareTo(reqKernelVer) < 0) {
                    throw new ModuleException("Module " + newModule.getName() + " requires kernel version " + reqKernelVer + " or higher.");
                }
                Logger.debug(4, "Module found: " + newModule.getNamespace() + " - " + newModule.getName());
                loadedModules.add(newModule.getName());
                moduleNs.add(newModule.getNamespace());
            }
            catch (ModuleException e) {
                Logger.error("Could not load module description from " + newModuleURL);
                throw e;
            }
            catch (Exception e) {
                Logger.error(e);
                throw new ModuleException("Could not load module.xml from " + newModuleURL);
            }
        }
        Logger.debug(5, "Checking dependencies");
        boolean allDepsPresent = true;
        ArrayList<String> prevModules = new ArrayList<String>();
        for (int i = 0; i < this.modules.size(); ++i) {
            boolean depClean = false;
            int skipped = 0;
            Module thisMod = this.modules.get(i);
            Logger.msg(5, "Checking dependencies of module " + thisMod.getName());
            while (!depClean) {
                ArrayList<String> deps = thisMod.getDependencies();
                depClean = true;
                for (String dep : deps) {
                    Logger.msg(6, thisMod.getName() + " depends on " + dep);
                    if (!loadedModules.contains(dep)) {
                        Logger.error("UNMET MODULE DEPENDENCY: " + thisMod.getName() + " requires " + dep);
                        allDepsPresent = false;
                        continue;
                    }
                    if (prevModules.contains(dep)) continue;
                    Logger.msg(1, "ModuleManager: Shuffling " + thisMod.getName() + " to the end to fulfil dependency on " + dep);
                    this.modules.remove(i);
                    this.modules.add(thisMod);
                    thisMod = this.modules.get(i);
                    ++skipped;
                    depClean = false;
                    break;
                }
                if (skipped <= this.modules.size() - i) continue;
                StringBuffer badMod = new StringBuffer();
                for (Module mod : this.modules.subList(i, this.modules.size())) {
                    badMod.append(mod.getName()).append(" ");
                }
                Logger.die("Circular module dependencies involving: " + badMod);
            }
            Properties modProp = thisMod.getProperties(isServer);
            Enumeration<?> e = modProp.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                this.props.put(propName, modProp.get(propName));
            }
            prevModules.add(thisMod.getName());
        }
        if (!allDepsPresent) {
            Logger.die("Unmet module dependencies. Cannot continue");
        }
    }

    public void setUser(AgentProxy user) {
        this.user = user;
    }

    public String getModuleVersions() {
        StringBuffer ver = new StringBuffer();
        for (Module thisMod : this.modules) {
            if (ver.length() > 0) {
                ver.append("; ");
            }
            ver.append(thisMod.getName() + " (" + thisMod.getVersion() + ")");
        }
        return ver.toString();
    }

    public Properties getAllModuleProperties() {
        return this.props;
    }

    public void runScripts(String event) {
        for (Module thisMod : this.modules) {
            if (Bootstrap.shutdown) {
                return;
            }
            try {
                thisMod.runScript(event, this.user, this.isServer);
            }
            catch (ScriptingEngineException e) {
                Logger.error(e);
                Logger.die(e.getMessage());
            }
        }
    }

    public void registerModules() throws ModuleException {
        ItemProxy serverItem;
        try {
            serverItem = Gateway.getProxyManager().getProxy(new DomainPath("/servers/" + Gateway.getProperties().getString("ItemServer.name")));
        }
        catch (ObjectNotFoundException e) {
            throw new ModuleException("Cannot find local server name.");
        }
        Logger.debug(3, "Registering modules");
        boolean reset = Gateway.getProperties().getBoolean("Module.reset", false);
        for (Module thisMod : this.modules) {
            if (Bootstrap.shutdown) {
                return;
            }
            Logger.msg("Registering module " + thisMod.getName());
            try {
                String thisResetKey = "Module." + thisMod.getNamespace() + ".reset";
                boolean thisReset = reset;
                if (Gateway.getProperties().containsKey(thisResetKey)) {
                    thisReset = Gateway.getProperties().getBoolean(thisResetKey);
                }
                thisMod.importAll(serverItem, this.user, this.modulesXML.get(thisMod.getNamespace()), thisReset);
            }
            catch (Exception e) {
                Logger.error(e);
                throw new ModuleException("Error importing items for module " + thisMod.getName());
            }
            Logger.msg("Module " + thisMod.getName() + " registered");
            try {
                thisMod.runScript("startup", this.user, true);
            }
            catch (ScriptingEngineException e) {
                Logger.error(e);
                throw new ModuleException("Error in startup script for module " + thisMod.getName());
            }
        }
    }

    public void dumpModules() {
        for (Module thisMod : this.modules) {
            try {
                FileStringUtility.string2File(thisMod.getName() + ".xml", Gateway.getMarshaller().marshall(thisMod));
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
    }
}

