/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.resource;

import java.util.HashSet;
import java.util.Set;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.LocalObjectLoader;

public class DefaultResourceImportHandler
implements ResourceImportHandler {
    String schemaName;
    String typeRoot;
    DomainPath typeRootPath;
    String wfDef;
    PropertyDescriptionList props;

    public DefaultResourceImportHandler(String resType) throws Exception {
        if (resType.equals("CA")) {
            this.schemaName = "CompositeActivityDef";
            this.typeRoot = "/desc/ActivityDesc";
            this.wfDef = "ManageCompositeActDef";
        } else if (resType.equals("EA")) {
            this.schemaName = "ElementaryActivityDef";
            this.typeRoot = "/desc/ActivityDesc";
            this.wfDef = "ManageElementaryActDef";
        } else if (resType.equals("OD")) {
            this.schemaName = "Schema";
            this.typeRoot = "/desc/OutcomeDesc";
            this.wfDef = "ManageSchema";
        } else if (resType.equals("SC")) {
            this.schemaName = "Script";
            this.typeRoot = "/desc/Script";
            this.wfDef = "ManageScript";
        } else if (resType.equals("SM")) {
            this.schemaName = "StateMachine";
            this.typeRoot = "/desc/StateMachine";
            this.wfDef = "ManageStateMachine";
        } else {
            throw new Exception("Unknown bootstrap item type: " + resType);
        }
        this.typeRootPath = new DomainPath(this.typeRoot);
        this.props = (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(Gateway.getResource().getTextResource(null, "boot/property/" + resType + "Prop.xml"));
    }

    @Override
    public CollectionArrayList getCollections(String name, String ns, String location, Integer version) throws Exception {
        if (this.schemaName.endsWith("ActivityDef")) {
            String actData = Gateway.getResource().getTextResource(ns, location);
            ActivityDef actDef = (ActivityDef)Gateway.getMarshaller().unmarshall(actData);
            actDef.setVersion(version);
            return actDef.makeDescCollections();
        }
        if (this.schemaName.equals("Script")) {
            Script thisScript = new Script(name, version, null, Gateway.getResource().getTextResource(ns, location));
            return thisScript.makeDescCollections();
        }
        return new CollectionArrayList();
    }

    @Override
    public DomainPath getTypeRoot() {
        return this.typeRootPath;
    }

    @Override
    public String getName() {
        return this.schemaName;
    }

    @Override
    public DomainPath getPath(String name, String ns) throws Exception {
        return new DomainPath(this.typeRoot + "/system/" + (ns == null ? "kernel" : ns) + '/' + name);
    }

    @Override
    public Set<Outcome> getResourceOutcomes(String name, String ns, String location, Integer version) throws Exception {
        HashSet<Outcome> retArr = new HashSet<Outcome>();
        String data = Gateway.getResource().getTextResource(ns, location);
        if (data == null) {
            throw new Exception("No data found for " + this.schemaName + " " + name);
        }
        Outcome resOutcome = new Outcome(0, data, LocalObjectLoader.getSchema(this.schemaName, 0));
        retArr.add(resOutcome);
        return retArr;
    }

    @Override
    public PropertyDescriptionList getPropDesc() throws Exception {
        return this.props;
    }

    @Override
    public String getWorkflowName() throws Exception {
        return this.wfDef;
    }
}

