/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.property;

import java.util.ArrayList;
import java.util.Iterator;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.Logger;

public class PropertyUtility {
    public static String getValue(ArrayList<PropertyDescription> pdlist, String name) {
        for (PropertyDescription pd : pdlist) {
            if (!name.equalsIgnoreCase(pd.getName())) continue;
            return pd.getDefaultValue();
        }
        return null;
    }

    public static String getNames(ArrayList<PropertyDescription> pdlist) {
        StringBuffer names = new StringBuffer();
        for (PropertyDescription value : pdlist) {
            names.append(value.getDefaultValue()).append(" ");
        }
        return names.toString();
    }

    public static String getClassIdNames(ArrayList<PropertyDescription> pdlist) {
        StringBuffer names = new StringBuffer();
        Iterator<PropertyDescription> iter = pdlist.iterator();
        while (iter.hasNext()) {
            PropertyDescription pd = iter.next();
            if (pd.getIsClassIdentifier()) {
                names.append(pd.getName());
            }
            if (!iter.hasNext()) continue;
            names.append(",");
        }
        return names.toString();
    }

    public static PropertyDescriptionList getPropertyDescriptionOutcome(ItemPath itemPath, String descVer, Object locker) throws ObjectNotFoundException {
        try {
            Outcome outc = (Outcome)Gateway.getStorage().get(itemPath, "ViewPoint/PropertyDescription/" + descVer + "/data", locker);
            return (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(outc.getData());
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new ObjectNotFoundException("Could not fetch PropertyDescription from " + itemPath);
        }
    }

    public static CastorHashMap createProperty(PropertyDescriptionList pdList) {
        CastorHashMap props = new CastorHashMap();
        for (int i = 0; i < pdList.list.size(); ++i) {
            PropertyDescription pd = (PropertyDescription)pdList.list.get(i);
            if (!pd.getIsClassIdentifier()) continue;
            props.put(pd.getName(), pd.getDefaultValue());
        }
        return props;
    }
}

