/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.scripting;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Parameter;
import org.cristalise.kernel.scripting.ParameterException;
import org.cristalise.kernel.scripting.ScriptParsingException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Script
implements DescriptionObject {
    public static final String INCLCOLL = "Includes";
    String mScript = "";
    CompiledScript mCompScript = null;
    String mName;
    Integer mVersion;
    ItemPath mItemPath;
    HashMap<String, Parameter> mInputParams = new HashMap();
    HashMap<String, Parameter> mAllInputParams = new HashMap();
    HashMap<String, Parameter> mOutputParams = new HashMap();
    ArrayList<Script> mIncludes = new ArrayList();
    ScriptEngine engine;
    ScriptContext context;

    public Script(String name, Integer version, ItemPath path, String xml) throws ScriptParsingException, ParameterException {
        this.mName = name;
        this.mVersion = version;
        this.mItemPath = path;
        this.parseScriptXML(xml);
    }

    public Script(String lang, String expr, Class<?> returnType) throws ScriptingEngineException {
        this.mName = "<expr>";
        this.setScriptEngine(lang);
        this.mVersion = null;
        this.addOutput(null, returnType);
        this.setScriptData(expr);
    }

    public Script(String lang, String name, String expr, AgentProxy agent) throws ScriptingEngineException {
        this(lang, expr, Object.class);
        this.mName = name;
        this.addInputParam("agent", AgentProxy.class);
        this.setInputParamValue("agent", agent);
    }

    public Script(String lang, String expr) throws ScriptingEngineException {
        this(lang, expr, Object.class);
    }

    public Script(String lang, AgentProxy agent, PrintStream out) throws Exception {
        this.setScriptEngine(lang);
        Bindings beans = this.context.getBindings(100);
        beans.put("storage", (Object)Gateway.getStorage());
        beans.put("db", (Object)Gateway.getStorage().getDb());
        beans.put("proxy", (Object)Gateway.getProxyManager());
        beans.put("lookup", (Object)Gateway.getLookup());
        beans.put("orb", (Object)Gateway.getORB());
        beans.put("agent", (Object)agent);
        beans.put("output", (Object)out);
        PrintWriter output = new PrintWriter(out);
        this.context.setWriter(output);
        this.context.setErrorWriter(output);
        HashMap<String, String> consoleScripts = Gateway.getResource().getAllTextResources("textFiles/consoleScript." + lang + ".txt");
        for (String ns : consoleScripts.keySet()) {
            try {
                this.engine.put("javax.script.filename", ns + " init script");
                this.engine.eval(consoleScripts.get(ns));
            }
            catch (ScriptException ex) {
                out.println("Exception parsing console script for " + (ns == null ? "kernel" : ns + " module"));
                ex.printStackTrace(out);
            }
        }
        this.addOutput(null, Object.class);
    }

    public void setActExecEnvironment(ItemProxy object, AgentProxy subject, Job job) throws ScriptingEngineException, InvalidDataException {
        if (!this.mInputParams.containsKey("item")) {
            Logger.warning("Item param not declared in Script " + this.getName() + " v" + this.getVersion());
            this.addInputParam("item", ItemProxy.class);
        }
        this.setInputParamValue("item", object);
        if (!this.mInputParams.containsKey("agent")) {
            Logger.warning("Agent param not declared in Script " + this.getName() + " v" + this.getVersion());
            this.addInputParam("agent", AgentProxy.class);
        }
        this.setInputParamValue("agent", subject);
        if (!this.mInputParams.containsKey("job")) {
            Logger.warning("Job param not declared in Script " + this.getName() + " v" + this.getVersion());
            this.addInputParam("job", Job.class);
        }
        this.setInputParamValue("job", job);
        if (!this.mOutputParams.containsKey("errors")) {
            Logger.warning("Errors output not declared in Script " + this.getName() + " v" + this.getVersion());
            this.addOutput("errors", ErrorInfo.class);
        }
    }

    public void setScriptEngine(String requestedLang) throws ScriptingEngineException {
        String lang = Gateway.getProperties().getString("OverrideScriptLang." + requestedLang, requestedLang);
        ScriptEngineManager sem = (ScriptEngineManager)Gateway.getProperties().getObject("Script.EngineManager");
        if (sem == null) {
            sem = new ScriptEngineManager(this.getClass().getClassLoader());
        }
        this.engine = sem.getEngineByName(lang);
        if (this.engine == null) {
            throw new ScriptingEngineException("No script engine for '" + lang + "' found.");
        }
        Bindings beans = this.engine.createBindings();
        this.context = new SimpleScriptContext();
        this.context.setBindings(beans, 100);
        this.engine.setContext(this.context);
    }

    public void setContext(ScriptContext context) {
        this.context = context;
        if (this.engine != null) {
            this.engine.setContext(context);
        }
    }

    public ScriptContext getContext() {
        return this.context;
    }

    private void parseScriptXML(String scriptXML) throws ScriptParsingException, ParameterException {
        Document scriptDoc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder domBuilder = factory.newDocumentBuilder();
            scriptDoc = domBuilder.parse(new InputSource(new StringReader(scriptXML)));
        }
        catch (Exception ex) {
            throw new ScriptParsingException("Error parsing Script XML : " + ex.toString());
        }
        Element root = scriptDoc.getDocumentElement();
        Element scriptElem = (Element)scriptDoc.getElementsByTagName("script").item(0);
        if (!scriptElem.hasAttribute("language")) {
            throw new ScriptParsingException("Script data incomplete, must specify scripting language");
        }
        Logger.msg(6, "Script.parseScriptXML() - Script Language: " + scriptElem.getAttribute("language"));
        try {
            this.setScriptEngine(scriptElem.getAttribute("language"));
        }
        catch (ScriptingEngineException ex) {
            throw new ScriptParsingException(ex.getMessage());
        }
        NodeList scriptChildNodes = scriptElem.getChildNodes();
        if (scriptChildNodes.getLength() != 1) {
            throw new ScriptParsingException("More than one child element found under script tag. Script characters may need escaping - suggest convert to CDATA section");
        }
        if (!(scriptChildNodes.item(0) instanceof Text)) {
            throw new ScriptParsingException("Child element of script tag was not text");
        }
        this.setScriptData(((Text)scriptChildNodes.item(0)).getData());
        Logger.msg(6, "Script.parseScriptXML() - script:" + this.mScript);
        NodeList includeList = scriptDoc.getElementsByTagName("include");
        for (int i = 0; i < includeList.getLength(); ++i) {
            Element include = (Element)includeList.item(i);
            if (!include.hasAttribute("name") || !include.hasAttribute("version")) {
                throw new ScriptParsingException("Script include declaration incomplete, must have name and version");
            }
            String includeName = include.getAttribute("name");
            String includeVersion = include.getAttribute("version");
            try {
                Script includedScript = LocalObjectLoader.getScript(includeName, Integer.parseInt(includeVersion));
                includedScript.setContext(this.context);
                this.mIncludes.add(includedScript);
                for (Parameter includeParam : includedScript.getInputParams().values()) {
                    this.addIncludedInputParam(includeParam.getName(), includeParam.getType());
                }
                continue;
            }
            catch (NumberFormatException e) {
                throw new ScriptParsingException("Invalid version in imported script name:'" + includeName + "', version:'" + includeVersion + "'");
            }
            catch (ScriptingEngineException e) {
                Logger.error(e);
                throw new ScriptParsingException("Error parsing imported script " + includeName + " v" + includeVersion + ": " + e.getMessage());
            }
            catch (ObjectNotFoundException e) {
                Logger.error((Throwable)((Object)e));
                throw new ScriptParsingException("Error parsing imported script " + includeName + " v" + includeVersion + " not found.");
            }
            catch (InvalidDataException e) {
                Logger.error((Throwable)((Object)e));
                throw new ScriptParsingException("Error parsing imported script " + includeName + " v" + includeVersion + " was invalid: " + e.getMessage());
            }
        }
        NodeList paramList = scriptDoc.getElementsByTagName("param");
        for (int i = 0; i < paramList.getLength(); ++i) {
            Element param = (Element)paramList.item(i);
            if (!param.hasAttribute("name") || !param.hasAttribute("type")) {
                throw new ScriptParsingException("Script Input Param incomplete, must have name and type");
            }
            this.addInputParam(param.getAttribute("name"), param.getAttribute("type"));
        }
        NodeList outputList = scriptDoc.getElementsByTagName("output");
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element output = (Element)outputList.item(i);
            if (!output.hasAttribute("type")) {
                throw new ScriptParsingException("Script Output declaration incomplete, must have type");
            }
            this.addOutput(output.getAttribute("name"), output.getAttribute("type"));
        }
    }

    protected void addInputParam(String name, String type) throws ParameterException {
        try {
            this.addInputParam(name, Gateway.getResource().getClassForName(type));
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterException("Input parameter " + name + " specifies class " + type + " which was not found.");
        }
    }

    protected void addInputParam(String name, Class<?> type) throws ParameterException {
        Parameter inputParam = new Parameter(name, type);
        Logger.msg(6, "ScriptExecutor.parseScriptXML() - declared parameter " + name + " (" + type + ")");
        this.mInputParams.put(inputParam.getName(), inputParam);
        this.mAllInputParams.put(inputParam.getName(), inputParam);
    }

    protected void addIncludedInputParam(String name, Class<?> type) throws ParameterException {
        if (this.mAllInputParams.containsKey(name)) {
            Parameter existingParam = this.mAllInputParams.get(name);
            if (existingParam.getType() == type) {
                return;
            }
            throw new ParameterException("Parameter conflict. Parameter'" + name + "' is declared as  " + existingParam.getType().getName() + " is declared in another script as " + type.getName());
        }
        Parameter inputParam = new Parameter(name);
        inputParam.setType(type);
        this.mAllInputParams.put(inputParam.getName(), inputParam);
    }

    protected void addOutput(String name, String type) throws ParameterException {
        try {
            this.addOutput(name, Gateway.getResource().getClassForName(type));
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterException("Output parameter " + name + " specifies class " + type + " which was not found.");
        }
    }

    protected void addOutput(String name, Class<?> type) throws ParameterException {
        String outputName = name;
        Parameter outputParam = new Parameter(name, type);
        if (this.mOutputParams.containsKey(outputName)) {
            throw new ParameterException("Output parameter '" + outputName + "' declared more than once.");
        }
        this.mOutputParams.put(outputName, outputParam);
    }

    public HashMap<String, Parameter> getInputParams() {
        return this.mInputParams;
    }

    public HashMap<String, Parameter> getAllInputParams() {
        return this.mAllInputParams;
    }

    public boolean setInputParamValue(String name, Object value) throws ParameterException {
        Parameter param = this.mInputParams.get(name);
        boolean wasUsed = false;
        if (!this.mAllInputParams.containsKey(name)) {
            return false;
        }
        if (param != null) {
            if (!param.getType().isInstance(value)) {
                throw new ParameterException("Parameter " + name + " in script " + this.mName + " v" + this.mVersion + " is wrong type \n" + "Required: " + param.getType().toString() + "\n" + "Supplied: " + value.getClass().toString());
            }
            this.context.getBindings(100).put(name, value);
            Logger.msg(7, "Script.setInputParamValue() - " + name + ": " + value.toString());
            param.setInitialised(true);
            wasUsed = true;
        }
        for (Script importScript : this.mIncludes) {
            wasUsed |= importScript.setInputParamValue(name, value);
        }
        return wasUsed;
    }

    public Object execute() throws ScriptingEngineException {
        StringBuffer missingParams = new StringBuffer();
        for (Parameter thisParam : this.mInputParams.values()) {
            if (thisParam.getInitialised()) continue;
            missingParams.append(thisParam.getName()).append("\n");
        }
        if (missingParams.length() > 0) {
            throw new ScriptingEngineException("Execution aborted, the following declared parameters were not set: \n" + missingParams.toString());
        }
        for (Parameter outputParam : this.mOutputParams.values()) {
            Object emptyObject;
            if (outputParam.getName() == null || outputParam.getName().length() == 0) continue;
            Logger.msg(8, "Script.setOutput() - Initialising output bean '" + outputParam.getName() + "'");
            try {
                emptyObject = outputParam.getType().newInstance();
            }
            catch (Exception e) {
                emptyObject = null;
            }
            this.context.getBindings(100).put(outputParam.getName(), emptyObject);
        }
        for (Script importScript : this.mIncludes) {
            if (Logger.doLog(8)) {
                Logger.msg(8, "Import script:\n" + importScript.mScript);
            } else {
                Logger.msg(5, "Executing imported script " + importScript.getName() + " v" + importScript.getVersion());
            }
            importScript.execute();
        }
        Object returnValue = null;
        try {
            Logger.msg(7, "Script.execute() - Executing script");
            if (Logger.doLog(8)) {
                Logger.msg(8, "Script:\n" + this.mScript);
            }
            if (this.engine == null) {
                throw new ScriptingEngineException("Script engine not set. Cannot execute scripts.");
            }
            this.engine.put("javax.script.filename", this.mName);
            returnValue = this.mCompScript != null ? this.mCompScript.eval(this.context) : this.engine.eval(this.mScript);
            Logger.msg(7, "Script.execute() - script returned \"" + returnValue + "\"");
        }
        catch (Throwable ex) {
            throw new ScriptingEngineException("Error executing script " + this.getName() + ": " + ex.getMessage());
        }
        if (this.mOutputParams.size() == 0) {
            Logger.msg(4, "Script.execute() - No output params. Returning null.");
            return null;
        }
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        for (Parameter outputParam : this.mOutputParams.values()) {
            String outputName = outputParam.getName();
            Object outputValue = outputName == null || outputName.length() == 0 ? returnValue : this.context.getBindings(100).get(outputParam.getName());
            if (outputValue != null || outputName != null) {
                Logger.msg(4, "Script.execute() - Output parameter" + (outputName == null ? " " : outputName + " ") + "= " + (outputValue == null ? "null" : outputValue.toString()));
            }
            if (outputValue != null && !outputParam.getType().isInstance(outputValue)) {
                throw new ScriptingEngineException("Script output " + outputName + " was not null or instance of " + outputParam.getType().getName() + ", it was a " + outputValue.getClass().getName());
            }
            Logger.msg(8, "Script.execute() - output " + outputValue);
            if (this.mOutputParams.size() == 1) {
                Logger.msg(6, "Script.execute() - only one parameter, returning " + (outputValue == null ? "null" : outputValue.toString()));
                return outputValue;
            }
            outputs.put(outputParam.getName(), outputValue);
        }
        return outputs;
    }

    public void setScriptData(String script) throws ScriptParsingException {
        this.mScript = script;
        if (this.engine instanceof Compilable) {
            try {
                Logger.msg(1, "Compiling script " + this.mName);
                this.engine.put("javax.script.filename", this.mName);
                this.mCompScript = ((Compilable)((Object)this.engine)).compile(this.mScript);
            }
            catch (ScriptException e) {
                throw new ScriptParsingException(e.getMessage());
            }
        }
    }

    public String getScriptData() {
        return this.mScript;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public Integer getVersion() {
        return this.mVersion;
    }

    @Override
    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    @Override
    public String getItemID() {
        return this.mItemPath.getUUID().toString();
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public void setVersion(Integer version) {
        this.mVersion = version;
    }

    @Override
    public void setItemPath(ItemPath path) {
        this.mItemPath = path;
    }

    @Override
    public CollectionArrayList makeDescCollections() throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = new CollectionArrayList();
        Dependency includeColl = new Dependency(INCLCOLL);
        for (Script script : this.mIncludes) {
            try {
                includeColl.addMember(script.getItemPath());
            }
            catch (InvalidCollectionModification e) {
                throw new InvalidDataException("Could not add " + script.getName() + " to description collection. " + e.getMessage());
            }
            catch (ObjectAlreadyExistsException e) {
                throw new InvalidDataException("Script " + script.getName() + " included more than once.");
            }
        }
        retArr.put(includeColl);
        return retArr;
    }

    @Override
    public void export(Writer imports, File dir) throws IOException {
        FileStringUtility.string2File(new File(new File(dir, "SC"), this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), this.getScriptData());
        if (imports != null) {
            imports.write("<Resource name=\"" + this.getName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\" ") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ") + "type=\"SC\">boot/SC/" + this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml</Resource>\n");
        }
    }

    public static void main(String[] args) {
        for (ScriptEngineFactory sef : new ScriptEngineManager().getEngineFactories()) {
            System.out.println(sef.getEngineName() + " v" + sef.getEngineVersion() + " using " + sef.getLanguageName() + " v" + sef.getLanguageVersion() + " " + sef.getNames());
        }
        System.out.println("Preferred javascript engine: " + new ScriptEngineManager().getEngineByName("javascript").getClass().getName());
    }
}

