/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.DescriptionObjectCache;
import org.cristalise.kernel.utils.Logger;

public class ActDefCache
extends DescriptionObjectCache<ActivityDef> {
    Boolean isComposite;

    public ActDefCache(Boolean isComposite) {
        this.isComposite = isComposite;
    }

    @Override
    public String getTypeCode() {
        if (this.isComposite == null) {
            return "AC";
        }
        return this.isComposite != false ? "CA" : "EA";
    }

    @Override
    public String getSchemaName() {
        if (this.isComposite == null) {
            return "ActivityDef";
        }
        return this.isComposite != false ? "CompositeActivityDef" : "ActivityDef";
    }

    @Override
    protected boolean isBootResource(String filename, String resName) {
        if (this.isComposite == null) {
            return filename.endsWith("/" + resName) && (filename.startsWith("CA") || filename.startsWith("EA"));
        }
        return super.isBootResource(filename, resName);
    }

    @Override
    public ActivityDef loadObject(String name, int version, ItemProxy proxy) throws ObjectNotFoundException, InvalidDataException {
        String marshalledAct;
        String actType = this.isComposite == null ? proxy.getProperty("Complexity") : (this.isComposite != false ? "Composite" : "Elementary");
        Viewpoint actView = (Viewpoint)proxy.getObject("ViewPoint/" + actType + "ActivityDef/" + version);
        try {
            marshalledAct = actView.getOutcome().getData();
        }
        catch (PersistencyException ex) {
            Logger.error((Throwable)((Object)ex));
            throw new ObjectNotFoundException("Problem loading " + name + " v" + version + ": " + ex.getMessage());
        }
        return this.buildObject(name, version, proxy.getPath(), marshalledAct);
    }

    @Override
    public ActivityDef buildObject(String name, int version, ItemPath path, String data) throws InvalidDataException {
        try {
            ActivityDef thisActDef = (ActivityDef)Gateway.getMarshaller().unmarshall(data);
            thisActDef.getProperties().put("Version", version);
            thisActDef.setName(name);
            thisActDef.setVersion(version);
            thisActDef.setItemPath(path);
            return thisActDef;
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new InvalidDataException("Could not unmarshall '" + name + "' v" + version + ": " + ex.getMessage());
        }
    }
}

