/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.cristalise.kernel.utils.KeyValuePair;

public class CastorHashMap
extends HashMap<String, Object> {
    ArrayList<String> abstractPropNames = new ArrayList();

    public CastorHashMap() {
        this.clear();
    }

    public KeyValuePair[] getKeyValuePairs() {
        int numKeys = this.size();
        KeyValuePair[] keyValuePairs = new KeyValuePair[numKeys];
        Iterator keyIter = this.keySet().iterator();
        int i = 0;
        for (i = 0; i < numKeys; ++i) {
            if (!keyIter.hasNext()) continue;
            String name = (String)keyIter.next();
            keyValuePairs[i] = new KeyValuePair(name, this.get(name), this.abstractPropNames.contains(name));
        }
        return keyValuePairs;
    }

    public void setKeyValuePairs(KeyValuePair[] keyValuePairs) {
        int i = 0;
        this.clear();
        for (i = 0; i < keyValuePairs.length; ++i) {
            this.setKeyValuePair(keyValuePairs[i]);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.abstractPropNames = new ArrayList();
    }

    public void setKeyValuePair(KeyValuePair keyValuePair) {
        this.put(keyValuePair.getKey(), keyValuePair.getValue());
        if (keyValuePair.isAbstract()) {
            this.abstractPropNames.add(keyValuePair.getKey());
        } else {
            this.abstractPropNames.remove(keyValuePair.getKey());
        }
    }

    public ArrayList<String> getAbstract() {
        return this.abstractPropNames;
    }

    public boolean isAbstract(String propName) {
        return this.abstractPropNames.contains(propName);
    }

    public void put(String key, Object value, boolean isAbstract) {
        super.put(key, value);
        if (isAbstract) {
            this.abstractPropNames.add(key);
        } else {
            this.abstractPropNames.remove(key);
        }
    }
}

