/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.util.Calendar;
import org.cristalise.kernel.common.GTimeStamp;

public class DateUtility {
    public static GTimeStamp setToNow(GTimeStamp date) {
        Calendar now = Calendar.getInstance();
        date.mYear = now.get(1);
        date.mMonth = now.get(2) + 1;
        date.mDay = now.get(5);
        date.mHour = now.get(11);
        date.mMinute = now.get(12);
        date.mSecond = now.get(13);
        date.mTimeOffset = now.get(15);
        return date;
    }

    public static String getSQLFormat(GTimeStamp timeStamp) {
        StringBuffer time = new StringBuffer().append(timeStamp.mYear).append("-");
        if (timeStamp.mMonth < 10) {
            time.append("0");
        }
        time.append(timeStamp.mMonth).append("-");
        if (timeStamp.mDay < 10) {
            time.append("0");
        }
        time.append(timeStamp.mDay).append(" ");
        if (timeStamp.mHour < 10) {
            time.append("0");
        }
        time.append(timeStamp.mHour).append(":");
        if (timeStamp.mMinute < 10) {
            time.append("0");
        }
        time.append(timeStamp.mMinute).append(":");
        if (timeStamp.mSecond < 10) {
            time.append("0");
        }
        time.append(timeStamp.mSecond);
        return time.toString();
    }

    public static int getNbDayInYear(GTimeStamp date) {
        int centuary = date.mYear / 100;
        int cdivby4 = centuary / 4;
        int ydivby4 = date.mYear / 4;
        if (centuary * 100 - date.mYear == 0) {
            if (centuary == cdivby4 * 4) {
                return 366;
            }
            return 365;
        }
        if (date.mYear == ydivby4 * 4) {
            return 366;
        }
        return 365;
    }

    public static int getNbDayInMonth(GTimeStamp date) {
        switch (date.mMonth) {
            case 2: {
                if (DateUtility.getNbDayInYear(date) == 365) {
                    return 28;
                }
                return 29;
            }
            case 4: {
                return 30;
            }
            case 6: {
                return 30;
            }
            case 9: {
                return 30;
            }
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static long diff(GTimeStamp date1, GTimeStamp date2) {
        GTimeStamp tmp = new GTimeStamp(date1.mYear, date1.mMonth, date1.mDay, date1.mHour, date1.mMinute, date1.mSecond, date1.mTimeOffset);
        while (tmp.mYear - date2.mYear < 0) {
            while (tmp.mMonth < 13) {
                tmp.mDay -= DateUtility.getNbDayInMonth(tmp);
                ++tmp.mMonth;
            }
            tmp.mMonth = 1;
            ++tmp.mYear;
        }
        while (tmp.mYear - date2.mYear > 0) {
            while (tmp.mMonth > 1) {
                --tmp.mMonth;
                tmp.mDay += DateUtility.getNbDayInMonth(tmp);
            }
            tmp.mMonth = 12;
            tmp.mDay += DateUtility.getNbDayInMonth(tmp);
            --tmp.mYear;
        }
        while (tmp.mMonth - date2.mMonth < 0) {
            tmp.mDay -= DateUtility.getNbDayInMonth(tmp);
            ++tmp.mMonth;
        }
        while (tmp.mMonth - date2.mMonth > 0) {
            --tmp.mMonth;
            tmp.mDay += DateUtility.getNbDayInMonth(tmp);
        }
        return (((tmp.mDay - date2.mDay) * 24 + tmp.mHour - date2.mHour) * 60 + tmp.mMinute - date2.mMinute) * 60 + tmp.mSecond - date2.mSecond;
    }
}

