/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cristalise.kernel.utils.Logger;

public class FileStringUtility {
    public static String file2String(File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] bArray = (byte[])Array.newInstance(Byte.TYPE, (int)file.length());
        Logger.msg(8, "FileStringUtility.file2String() - Reading file '" + file.getAbsolutePath() + "'");
        fis.read(bArray, 0, (int)file.length());
        fis.close();
        Logger.msg(9, "FileStringUtility.file2String() - file '" + file.getAbsolutePath() + "' read.");
        return new String(bArray);
    }

    public static String file2String(String fileName) throws FileNotFoundException, IOException {
        return FileStringUtility.file2String(new File(fileName));
    }

    public static String url2String(URL location) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(location.openStream(), "UTF-8"));
        StringBuffer strbuf = new StringBuffer();
        String line = in.readLine();
        while (line != null) {
            strbuf.append(line).append('\n');
            line = in.readLine();
        }
        return strbuf.toString();
    }

    public static String[] file2StringArray(File file) throws FileNotFoundException, IOException {
        FileReader fr = new FileReader(file);
        BufferedReader buf = new BufferedReader(fr);
        Vector<String> lines = new Vector<String>();
        String thisLine = null;
        while ((thisLine = buf.readLine()) != null) {
            lines.addElement(thisLine);
        }
        buf.close();
        String[] lineArray = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            lineArray[i] = (String)lines.get(i);
        }
        return lineArray;
    }

    public static String[] file2StringArray(String fileName) throws FileNotFoundException, IOException {
        return FileStringUtility.file2StringArray(new File(fileName));
    }

    public static void string2File(File file, String data) throws FileNotFoundException, IOException {
        FileWriter thisFile = new FileWriter(file);
        BufferedWriter thisFileBuffer = new BufferedWriter(thisFile);
        Logger.msg(9, "FileStringUtility.string2File() - writing file '" + file.getAbsolutePath() + "'");
        thisFileBuffer.write(data);
        thisFileBuffer.close();
        Logger.msg(9, "FileStringUtility.string2File() - file '" + file.getAbsolutePath() + "' complete.");
    }

    public static void string2File(String fileName, String data) throws FileNotFoundException, IOException {
        FileStringUtility.string2File(new File(fileName), data);
    }

    public static boolean checkDir(String dirPath) {
        File dir = new File(dirPath);
        if (dir.isFile()) {
            Logger.error("FileStringUtility.checkDir() - '" + dir.getAbsolutePath() + "' is a file.");
            return false;
        }
        if (!dir.exists()) {
            Logger.msg(9, "FileStringUtility.checkDir() - directory '" + dir.getAbsolutePath() + "' does not exist.");
            return false;
        }
        return true;
    }

    public static boolean createNewDir(String dirPath) {
        File dir = new File(dirPath);
        if (dir.isFile()) {
            Logger.error("FileStringUtility.createNewDir() - '" + dir.getAbsolutePath() + "' is a file.");
            return false;
        }
        if (dir.exists()) {
            Logger.msg(8, "FileStringUtility.createNewDir() - '" + dir.getAbsolutePath() + "' already exists.");
            return false;
        }
        if (!dir.mkdirs()) {
            Logger.error("FileStringUtility - Could not create new directory '" + dir.getAbsolutePath() + "'");
            return false;
        }
        return true;
    }

    public static boolean deleteDir(String dirPath) {
        File dir = new File(dirPath);
        if (!FileStringUtility.checkDir(dirPath)) {
            Logger.msg(8, "FileStringUtility.deleteDir() - directory '" + dir.getAbsolutePath() + "' does not exist.");
            return false;
        }
        if (!dir.delete()) {
            if (dir.list().length != 0) {
                Logger.error("FileStringUtility.deleteDir() - cannot delete non-empty directory '" + dir.getAbsolutePath() + "'");
            } else {
                Logger.error("FileStringUtility.deleteDir() - directory '" + dir.getAbsolutePath() + "' could not be deleted.");
            }
            return false;
        }
        return true;
    }

    public static boolean deleteDir(String dirPath, boolean force, boolean recursive) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            Logger.error("FileStringUtility.deleteDir() - directory '" + dir.getAbsolutePath() + "' does not exist.");
            return false;
        }
        if (dir.isFile()) {
            if (force) {
                dir.delete();
                return true;
            }
            Logger.error("FileStringUtility.deleteDir() - '" + dir.getAbsolutePath() + "' was a file.");
            return false;
        }
        if (recursive) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                FileStringUtility.deleteDir(file.getAbsolutePath(), true, true);
            }
        }
        return FileStringUtility.deleteDir(dirPath);
    }

    public static ArrayList<String> listDir(String dirPath, boolean withDirs, boolean recursive) {
        File[] files;
        ArrayList<String> fileNames = new ArrayList<String>();
        File dir = new File(dirPath);
        if (!FileStringUtility.checkDir(dirPath)) {
            Logger.msg(8, "FileStringUtility.listDir() - directory '" + dir.getAbsolutePath() + "' does not exist.");
            return null;
        }
        for (File file : files = dir.listFiles()) {
            String fileName = file.getName();
            if (file.isFile()) {
                fileNames.add(dirPath + "/" + fileName);
                continue;
            }
            if (recursive) {
                fileNames.addAll(FileStringUtility.listDir(dirPath + "/" + fileName, withDirs, recursive));
            }
            if (!withDirs) continue;
            fileNames.add(dirPath + "/" + fileName);
        }
        return fileNames;
    }

    public static InputStream openTextStream(String source) {
        InputStream in = null;
        URL url = null;
        try {
            try {
                url = new URL(source);
                in = url.openStream();
            }
            catch (MalformedURLException e) {
                in = new FileInputStream(source);
            }
        }
        catch (IOException ex) {
            Logger.error("FileStringUtility.openTextStream() - could not load text stream:" + source);
        }
        return in;
    }

    public static Properties loadConfigFile(String configFile) {
        BufferedInputStream bin = null;
        InputStream in = FileStringUtility.openTextStream(configFile);
        Properties props = new Properties();
        if (in != null) {
            try {
                bin = new BufferedInputStream(in);
                props.load(bin);
                in.close();
            }
            catch (IOException ex) {
                Logger.error("FileStringUtility.loadConfigFile() - could not load configuration file '" + configFile + "'");
            }
        }
        return props;
    }

    public static Hashtable<String, String> loadLanguageFile(String configFile) {
        try {
            String language = FileStringUtility.file2String(configFile);
            Hashtable<String, String> props = new Hashtable<String, String>();
            StringTokenizer tok = new StringTokenizer(language, "\n");
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                int sep = t.indexOf("=");
                if (sep <= 0) continue;
                props.put(t.substring(0, sep), t.substring(sep + 1));
            }
            return props;
        }
        catch (Exception e) {
            Logger.error("FileStringUtility.loadLanguageFile() - could not load language file '" + configFile + "'");
            Logger.error(e);
            return new Hashtable<String, String>();
        }
    }

    public static void appendConfigFile(Properties props, String configFile) {
        BufferedInputStream bin = null;
        InputStream in = FileStringUtility.openTextStream(configFile);
        if (in != null) {
            try {
                bin = new BufferedInputStream(in);
                props.load(bin);
                in.close();
            }
            catch (IOException ex) {
                Logger.error("FileStringUtility.appendConfigFile() - could not append configuration file '" + configFile + "'");
            }
        }
    }

    public static String convert(String init) {
        if (init == null) {
            return null;
        }
        return init.replace('\'', '_').replace('\\', '_').replace('/', '_').replace('\"', '_').replace(':', '_').replace('*', '_').replace('?', '_').replace('<', '_').replace('>', '_').replace('|', '_').replace('(', '[').replace(')', ']').replace(',', '_');
    }

    public static String replaceall(String src, String from, String to) {
        StringBuffer tmp = new StringBuffer(src);
        int length = from.length();
        int index = tmp.toString().indexOf(from);
        while (index > 0) {
            tmp.replace(index, index + length, to);
            index = tmp.toString().indexOf(from);
        }
        return tmp.toString();
    }

    public static String toAlphaNum(String source) {
        byte[] sourceb = source.getBytes();
        for (int i = 0; i < sourceb.length; ++i) {
            if (!(sourceb[i] < 48 || sourceb[i] > 57 && sourceb[i] < 65 || sourceb[i] > 90 && sourceb[i] < 95) && sourceb[i] <= 122) continue;
            sourceb[i] = 95;
        }
        return new String(sourceb);
    }
}

