/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.ActDefCache;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.SchemaCache;
import org.cristalise.kernel.utils.ScriptCache;
import org.cristalise.kernel.utils.StateMachineCache;

public class LocalObjectLoader {
    private static ActDefCache actCache = new ActDefCache(null);
    private static ActDefCache compActCache = new ActDefCache(true);
    private static ActDefCache elemActCache = new ActDefCache(false);
    private static StateMachineCache smCache = new StateMachineCache();
    private static SchemaCache schCache = new SchemaCache();
    private static ScriptCache scrCache = new ScriptCache();

    public static Script getScript(String scriptName, int scriptVersion) throws ObjectNotFoundException, InvalidDataException {
        Logger.msg(5, "Loading script " + scriptName + " v" + scriptVersion);
        return (Script)scrCache.get(scriptName, scriptVersion);
    }

    public static Schema getSchema(String schemaName, int schemaVersion) throws ObjectNotFoundException, InvalidDataException {
        Logger.msg(5, "Loading schema " + schemaName + " v" + schemaVersion);
        if (schemaName.equals("Schema") && schemaVersion == 0) {
            return new Schema(schemaName, schemaVersion, new ItemPath(new SystemKey(0L, 5L)), "");
        }
        return (Schema)schCache.get(schemaName, schemaVersion);
    }

    public static ActivityDef getActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        Logger.msg(5, "Loading activity def " + actName + " v" + actVersion);
        return (ActivityDef)actCache.get(actName, actVersion);
    }

    public static CompositeActivityDef getCompActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        Logger.msg(5, "Loading activity def " + actName + " v" + actVersion);
        return (CompositeActivityDef)compActCache.get(actName, actVersion);
    }

    public static ActivityDef getElemActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        Logger.msg(5, "Loading activity def " + actName + " v" + actVersion);
        return (ActivityDef)elemActCache.get(actName, actVersion);
    }

    public static StateMachine getStateMachine(String smName, int smVersion) throws ObjectNotFoundException, InvalidDataException {
        Logger.msg(5, "Loading activity state machine " + smName + " v" + smVersion);
        return (StateMachine)smCache.get(smName, smVersion);
    }
}

