/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage;

import java.io.File;
import java.util.ArrayList;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class XMLClusterStorage
extends ClusterStorage {
    String rootDir = null;

    @Override
    public void open(Authenticator auth) throws PersistencyException {
        String rootProp = Gateway.getProperties().getString("XMLStorage.root");
        if (rootProp == null) {
            throw new PersistencyException("XMLClusterStorage.open() - Root path not given in config file.");
        }
        this.rootDir = new File(rootProp).getAbsolutePath();
        if (!FileStringUtility.checkDir(this.rootDir)) {
            Logger.error("XMLClusterStorage.open() - Path " + this.rootDir + "' does not exist. Attempting to create.");
            boolean success = FileStringUtility.createNewDir(this.rootDir);
            if (!success) {
                throw new PersistencyException("XMLClusterStorage.open() - Could not create dir " + this.rootDir + ". Cannot continue.");
            }
        }
    }

    @Override
    public void close() {
        this.rootDir = null;
    }

    @Override
    public short queryClusterSupport(String clusterType) {
        return 3;
    }

    @Override
    public String getName() {
        return "XML File Cluster Storage";
    }

    @Override
    public String getId() {
        return "XML";
    }

    @Override
    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException {
        try {
            String type = ClusterStorage.getClusterType(path);
            String filePath = this.getFilePath(itemPath, path) + ".xml";
            String objString = FileStringUtility.file2String(filePath);
            if (objString.length() == 0) {
                return null;
            }
            Logger.debug(9, objString);
            if (type.equals("Outcome")) {
                return new Outcome(path, objString);
            }
            C2KLocalObject obj = (C2KLocalObject)Gateway.getMarshaller().unmarshall(objString);
            return obj;
        }
        catch (Exception e) {
            Logger.msg(3, "XMLClusterStorage.get() - The path " + path + " from " + itemPath + " does not exist.: " + e.getMessage());
            return null;
        }
    }

    @Override
    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        try {
            boolean success;
            String filePath = this.getFilePath(itemPath, XMLClusterStorage.getPath(obj) + ".xml");
            Logger.msg(7, "Writing " + filePath);
            String data = Gateway.getMarshaller().marshall(obj);
            String dir = filePath.substring(0, filePath.lastIndexOf(47));
            if (!FileStringUtility.checkDir(dir) && !(success = FileStringUtility.createNewDir(dir))) {
                throw new PersistencyException("XMLClusterStorage.put() - Could not create dir " + dir + ". Cannot continue.");
            }
            FileStringUtility.string2File(filePath, data);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new PersistencyException("XMLClusterStorage.put() - Could not write " + XMLClusterStorage.getPath(obj) + " to " + itemPath);
        }
    }

    @Override
    public void delete(ItemPath itemPath, String path) throws PersistencyException {
        try {
            String filePath = this.getFilePath(itemPath, path + ".xml");
            boolean success = FileStringUtility.deleteDir(filePath, true, true);
            if (success) {
                return;
            }
            filePath = this.getFilePath(itemPath, path);
            success = FileStringUtility.deleteDir(filePath, true, true);
            if (success) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new PersistencyException("XMLClusterStorage.delete() - Failure deleting path " + path + " in " + itemPath);
    }

    @Override
    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        String[] result = new String[]{};
        try {
            String filePath = this.getFilePath(itemPath, path);
            ArrayList<String> paths = FileStringUtility.listDir(filePath, true, false);
            if (paths == null) {
                return result;
            }
            ArrayList<String> contents = new ArrayList<String>();
            String previous = null;
            for (int i = 0; i < paths.size(); ++i) {
                String next = paths.get(i);
                if (next.endsWith(".xml")) {
                    next = next.substring(0, next.length() - 4);
                }
                if (next.equals(previous)) continue;
                previous = next;
                if (next.indexOf(47) > -1) {
                    next = next.substring(next.lastIndexOf(47) + 1);
                }
                contents.add(next);
            }
            result = contents.toArray(result);
            return result;
        }
        catch (Exception e) {
            Logger.error(e);
            throw new PersistencyException("XMLClusterStorage.getClusterContents() - Could not get contents of " + path + " from " + itemPath + ": " + e.getMessage());
        }
    }

    protected String getFilePath(ItemPath itemPath, String path) throws InvalidItemPathException {
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = "/" + path;
        }
        String filePath = this.rootDir + itemPath.toString() + path;
        Logger.msg(8, "XMLClusterStorage.getFilePath() - " + filePath);
        return filePath;
    }
}

