/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.util.List;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.AgentOperations;
import org.cristalise.kernel.entity.ItemImplementation;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.AgentPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class AgentImplementation
extends ItemImplementation
implements AgentOperations {
    private JobList currentJobs;
    private final AgentPath mAgentPath;

    public AgentImplementation(AgentPath path) {
        super(path);
        this.mAgentPath = path;
    }

    @Override
    public synchronized void refreshJobList(SystemKey sysKey, String stepPath, String newJobs) {
        try {
            ItemPath itemPath = new ItemPath(sysKey);
            JobArrayList newJobList = (JobArrayList)Gateway.getMarshaller().unmarshall(newJobs);
            if (this.currentJobs == null) {
                this.currentJobs = new JobList(this.mAgentPath, null);
            }
            List<String> keysToRemove = this.currentJobs.getKeysForStep(itemPath, stepPath);
            for (Object name : newJobList.list) {
                Job newJob = (Job)name;
                Logger.msg(6, "AgentImplementation.refreshJobList() - Adding job:" + newJob.getItemPath() + "/" + newJob.getStepPath() + ":" + newJob.getTransition().getName());
                this.currentJobs.addJob(newJob);
            }
            for (String key : keysToRemove) {
                this.currentJobs.remove(key);
            }
        }
        catch (Throwable ex) {
            Logger.error("Could not refresh job list.");
            Logger.error(ex);
        }
    }

    @Override
    public void addRole(String roleName) throws CannotManageException, ObjectNotFoundException {
        RolePath newRole = Gateway.getLookup().getRolePath(roleName);
        try {
            Gateway.getLookupManager().addRole(this.mAgentPath, newRole);
        }
        catch (ObjectCannotBeUpdated ex) {
            throw new CannotManageException("Could not update role");
        }
    }

    @Override
    public void removeRole(String roleName) throws CannotManageException, ObjectNotFoundException {
        RolePath rolePath = Gateway.getLookup().getRolePath(roleName);
        try {
            Gateway.getLookupManager().removeRole(this.mAgentPath, rolePath);
        }
        catch (ObjectCannotBeUpdated ex) {
            throw new CannotManageException("Could not update role");
        }
    }

    @Override
    protected PredefinedStepContainer getNewPredefStepContainer() {
        return new AgentPredefinedStepContainer();
    }
}

