/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.Item;
import org.cristalise.kernel.entity.ItemHelper;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.CastorXMLUtility;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;

public class ItemProxy {
    protected Item mItem = null;
    protected ItemPath mItemPath;
    protected Object mIOR;
    private final HashMap<MemberSubscription<?>, ProxyObserver<?>> mSubscriptions;

    protected ItemProxy(Object ior, ItemPath itemPath) {
        Logger.msg(8, "ItemProxy::initialise() - path:" + itemPath);
        this.mIOR = ior;
        this.mItemPath = itemPath;
        this.mSubscriptions = new HashMap();
    }

    public ItemPath getPath() {
        return this.mItemPath;
    }

    protected Item getItem() throws ObjectNotFoundException {
        if (this.mItem == null) {
            this.mItem = this.narrow();
        }
        return this.mItem;
    }

    public Item narrow() throws ObjectNotFoundException {
        try {
            return ItemHelper.narrow(this.mIOR);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new ObjectNotFoundException("CORBA Object was not an Item, or the server is down.");
        }
    }

    public void initialise(AgentPath agentId, PropertyArrayList itemProps, CompositeActivity workflow, CollectionArrayList colls) throws AccessRightsException, InvalidDataException, PersistencyException, ObjectNotFoundException, MarshalException, ValidationException, IOException, MappingException, InvalidCollectionModification {
        Logger.msg(7, "ItemProxy.initialise() - started");
        CastorXMLUtility xml = Gateway.getMarshaller();
        if (itemProps == null) {
            throw new InvalidDataException("ItemProxy.initialise() - No initial properties supplied");
        }
        String propString = xml.marshall(itemProps);
        String wfString = "";
        if (workflow != null) {
            wfString = xml.marshall(workflow);
        }
        String collString = "";
        if (colls != null) {
            collString = xml.marshall(colls);
        }
        this.getItem().initialise(agentId.getSystemKey(), propString, wfString, collString);
    }

    public void setProperty(AgentProxy agent, String name, String value) throws AccessRightsException, PersistencyException, InvalidDataException {
        String[] params = new String[]{name, value};
        try {
            agent.execute(this, "WriteProperty", params);
        }
        catch (AccessRightsException e) {
            throw e;
        }
        catch (PersistencyException e) {
            throw e;
        }
        catch (InvalidDataException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error(e);
            throw new PersistencyException("Could not store property");
        }
    }

    public String requestAction(Job thisJob) throws AccessRightsException, InvalidTransitionException, ObjectNotFoundException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        String outcome = thisJob.getOutcomeString();
        if (outcome == null) {
            if (thisJob.isOutcomeRequired()) {
                throw new InvalidDataException("Outcome is required.");
            }
            outcome = "";
        }
        if (thisJob.getAgentPath() == null) {
            throw new InvalidDataException("No Agent specified.");
        }
        Logger.msg(7, "ItemProxy.requestAction() - executing " + thisJob.getStepPath() + " for " + thisJob.getAgentName());
        if (thisJob.getDelegatePath() == null) {
            return this.getItem().requestAction(thisJob.getAgentPath().getSystemKey(), thisJob.getStepPath(), thisJob.getTransition().getId(), outcome);
        }
        return this.getItem().delegatedAction(thisJob.getAgentPath().getSystemKey(), thisJob.getDelegatePath().getSystemKey(), thisJob.getStepPath(), thisJob.getTransition().getId(), outcome);
    }

    private ArrayList<Job> getJobList(AgentPath agentPath, boolean filter) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        JobArrayList thisJobList;
        String jobs = this.getItem().queryLifeCycle(agentPath.getSystemKey(), filter);
        try {
            thisJobList = (JobArrayList)Gateway.getMarshaller().unmarshall(jobs);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new PersistencyException("Exception::ItemProxy::getJobList() - Cannot unmarshall the jobs");
        }
        return thisJobList.list;
    }

    public ArrayList<Job> getJobList(AgentProxy agent) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        return this.getJobList(agent.getPath(), true);
    }

    private Job getJobByName(String actName, AgentPath agent) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        ArrayList<Job> jobList = this.getJobList(agent, true);
        for (Job job : jobList) {
            if (!job.getStepName().equals(actName) || !job.getTransition().isFinishing()) continue;
            return job;
        }
        return null;
    }

    public Collection<?> getCollection(BuiltInCollections collection) throws ObjectNotFoundException {
        return this.getCollection(collection, null);
    }

    public Collection<?> getCollection(BuiltInCollections collection, Integer version) throws ObjectNotFoundException {
        return this.getCollection(collection.getName(), version);
    }

    public Collection<?> getCollection(String collName) throws ObjectNotFoundException {
        return this.getCollection(collName, null);
    }

    public Collection<?> getCollection(String collName, Integer version) throws ObjectNotFoundException {
        String verStr = version == null ? "last" : String.valueOf(version);
        return (Collection)this.getObject("Collection/" + collName + "/" + verStr);
    }

    public Workflow getWorkflow() throws ObjectNotFoundException {
        return (Workflow)this.getObject("LifeCycle/workflow");
    }

    public boolean checkViewpoint(String schemaName, String viewName) throws ObjectNotFoundException {
        return this.checkContent("ViewPoint/" + schemaName, viewName);
    }

    public Viewpoint getViewpoint(String schemaName, String viewName) throws ObjectNotFoundException {
        return (Viewpoint)this.getObject("ViewPoint/" + schemaName + "/" + viewName);
    }

    public Job getJobByName(String actName, AgentProxy agent) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        return this.getJobByName(actName, agent.getPath());
    }

    public Job getJobByTransitionName(String actName, String transName, AgentProxy agent) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        return this.getJobByTransitionName(actName, transName, agent.getPath());
    }

    public Job getJobByTransitionName(String actName, String transName, AgentPath agentPath) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        for (Job job : this.getJobList(agentPath, true)) {
            if (!job.getStepName().equals(actName) || !job.getTransition().getName().equals(transName)) continue;
            return job;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        Logger.msg(7, "ItemProxy.finalize() - caches are reaped for item:" + this.mItemPath);
        Gateway.getStorage().clearCache(this.mItemPath, null);
        Gateway.getProxyManager().removeProxy(this.mItemPath);
        super.finalize();
    }

    public String queryData(String path) throws ObjectNotFoundException {
        try {
            Logger.msg(7, "ItemProxy.queryData() - " + this.mItemPath + "/" + path);
            if (path.endsWith("all")) {
                Logger.msg(7, "ItemProxy.queryData() - listing contents");
                String[] result = Gateway.getStorage().getClusterContents(this.mItemPath, path.substring(0, path.length() - 3));
                StringBuffer retString = new StringBuffer();
                for (int i = 0; i < result.length; ++i) {
                    retString.append(result[i]);
                    if (i >= result.length - 1) continue;
                    retString.append(",");
                }
                Logger.msg(7, "ItemProxy.queryData() - " + retString.toString());
                return retString.toString();
            }
            C2KLocalObject target = Gateway.getStorage().get(this.mItemPath, path, null);
            return Gateway.getMarshaller().marshall(target);
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error(e);
            return "<ERROR>" + e.getMessage() + "</ERROR>";
        }
    }

    public boolean checkContent(String path, String name) throws ObjectNotFoundException {
        for (String key : this.getContents(path)) {
            if (!key.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getContents(String path) throws ObjectNotFoundException {
        try {
            return Gateway.getStorage().getClusterContents(this.mItemPath, path);
        }
        catch (PersistencyException e) {
            throw new ObjectNotFoundException(e.toString());
        }
    }

    public String executeQuery(Query query) throws PersistencyException {
        return Gateway.getStorage().executeQuery(query);
    }

    public C2KLocalObject getObject(String xpath) throws ObjectNotFoundException {
        try {
            return Gateway.getStorage().get(this.mItemPath, xpath, null);
        }
        catch (PersistencyException ex) {
            Logger.error("ItemProxy.getObject() - Exception loading object:" + this.mItemPath + "/" + xpath);
            Logger.error((Throwable)((java.lang.Object)ex));
            throw new ObjectNotFoundException(ex.toString());
        }
    }

    public String getProperty(BuiltInItemProperties prop) throws ObjectNotFoundException {
        return this.getProperty(prop.getName());
    }

    public String getProperty(String name) throws ObjectNotFoundException {
        Logger.msg(5, "ItemProxy.getProperty() - " + name + " from item " + this.mItemPath);
        Property prop = (Property)this.getObject("Property/" + name);
        if (prop != null) {
            return prop.getValue();
        }
        throw new ObjectNotFoundException("ItemProxy.getProperty() - COULD not find property " + name + " from item " + this.mItemPath);
    }

    public String getName() {
        try {
            return this.getProperty(BuiltInItemProperties.NAME);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(MemberSubscription<?> newSub) {
        newSub.setSubject(this);
        ItemProxy itemProxy = this;
        synchronized (itemProxy) {
            this.mSubscriptions.put(newSub, newSub.getObserver());
        }
        new Thread(newSub).start();
        Logger.msg(7, "ItemProxy.subscribe() - " + newSub.getObserver().getClass().getName() + " for " + newSub.interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ProxyObserver<?> observer) {
        ItemProxy itemProxy = this;
        synchronized (itemProxy) {
            Iterator<MemberSubscription<?>> e = this.mSubscriptions.keySet().iterator();
            while (e.hasNext()) {
                MemberSubscription<?> thisSub = e.next();
                if (this.mSubscriptions.get(thisSub) != observer) continue;
                e.remove();
                Logger.msg(7, "ItemProxy.unsubscribed() - " + observer.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSubscriptions(int logLevel) {
        if (!Logger.doLog(logLevel) || this.mSubscriptions.size() == 0) {
            return;
        }
        Logger.msg(logLevel, "Subscriptions to proxy " + this.mItemPath + ":");
        ItemProxy itemProxy = this;
        synchronized (itemProxy) {
            for (MemberSubscription<?> element : this.mSubscriptions.keySet()) {
                ProxyObserver<?> obs = element.getObserver();
                if (obs != null) {
                    Logger.msg(logLevel, "    " + element.getObserver().getClass().getName() + " subscribed to " + element.interest);
                    continue;
                }
                Logger.msg(logLevel, "    Phantom subscription to " + element.interest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(ProxyMessage message) {
        Logger.msg(4, "ItemProxy.notify() - Received change notification for " + message.getPath() + " on " + this.mItemPath);
        ItemProxy itemProxy = this;
        synchronized (itemProxy) {
            if (Gateway.getProxyServer() == null || !message.getServer().equals(Gateway.getProxyServer().getServerName())) {
                Gateway.getStorage().clearCache(this.mItemPath, message.getPath());
            }
            Iterator<MemberSubscription<?>> e = this.mSubscriptions.keySet().iterator();
            while (e.hasNext()) {
                MemberSubscription<?> newSub = e.next();
                if (newSub.getObserver() == null) {
                    Logger.msg(4, "ItemProxy.notify() - Removing phantom subscription to " + newSub.interest);
                    e.remove();
                    continue;
                }
                newSub.update(message.getPath(), message.getState());
            }
        }
    }
}

