/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.server.SocketHandler;

public class ProxyClientConnection
implements SocketHandler {
    static int clientId = -1;
    Socket clientSocket = null;
    int thisClientId = ++clientId;
    ArrayList<ItemPath> subscribedItems;
    PrintWriter response;
    BufferedReader request;
    boolean closing = false;

    public ProxyClientConnection() {
        Gateway.getProxyServer().registerProxyClient(this);
        Logger.msg(1, "ProxyClientConnection() - clientID:" + this.thisClientId + " READY.");
    }

    @Override
    public String getName() {
        return "Proxy Client Connection";
    }

    @Override
    public boolean isBusy() {
        return this.clientSocket != null;
    }

    @Override
    public synchronized void setSocket(Socket newSocket) {
        try {
            Logger.msg(1, "ProxyClientConnection.setSocket() - clientID " + this.thisClientId + " connect from " + newSocket.getInetAddress() + ":" + newSocket.getPort());
            newSocket.setSoTimeout(500);
            this.clientSocket = newSocket;
            this.response = new PrintWriter(this.clientSocket.getOutputStream(), true);
            this.subscribedItems = new ArrayList();
        }
        catch (SocketException ex) {
            Logger.error("ProxyClientConnection.setSocket() - Could not set socket timeout:");
            Logger.error(ex);
            this.closeSocket();
        }
        catch (IOException ex) {
            Logger.error("ProxyClientConnection.setSocket() - Could not setup output stream:");
            Logger.error(ex);
            this.closeSocket();
        }
    }

    @Override
    public void run() {
        block6: {
            Thread.currentThread().setName(this.getName() + ": " + this.clientSocket.getInetAddress());
            Logger.msg(7, "ProxyClientConnection.run() - clientID:" + this.thisClientId + " - Setting up proxy client connection with " + this.clientSocket.getInetAddress());
            try {
                this.request = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                String input = null;
                while (this.clientSocket != null) {
                    try {
                        input = this.request.readLine();
                        Logger.msg(9, "ProxyClientConnection.run() - " + this.thisClientId + " - received " + input);
                        ProxyMessage thisMessage = new ProxyMessage(input);
                        this.processMessage(thisMessage);
                    }
                    catch (InterruptedIOException ex) {
                    }
                    catch (InvalidDataException ex) {
                        Logger.error("ProxyClientConnection.run() - clientID:" + this.thisClientId + " - Invalid proxy message: " + input);
                    }
                }
            }
            catch (IOException ex) {
                if (this.closing) break block6;
                Logger.error("ProxyClientConnection.run() - clientID:" + this.thisClientId + " - Error reading from socket.");
            }
        }
        this.closeSocket();
        Logger.msg(1, "ProxyClientConnection.run() - clientID:" + this.thisClientId + " closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(ProxyMessage message) throws InvalidDataException {
        if (message.getPath().equals("bye")) {
            Logger.msg(7, "ProxyClientConnection.processMessage() - clientID:" + this.thisClientId + " disconnecting");
            this.closeSocket();
        } else if (message.getPath().equals("ping")) {
            this.response.println(ProxyMessage.pingMessage);
        } else {
            if (message.getPath().equals("add")) {
                Logger.msg(7, "ProxyClientConnection.processMessage() - clientID:" + this.thisClientId + " subscribed to " + message.getItemPath());
                ArrayList<ItemPath> arrayList = this.subscribedItems;
                synchronized (arrayList) {
                    this.subscribedItems.add(message.getItemPath());
                }
            }
            if (message.getPath().equals("del")) {
                ArrayList<ItemPath> arrayList = this.subscribedItems;
                synchronized (arrayList) {
                    this.subscribedItems.remove(message.getItemPath());
                }
                Logger.msg(7, "ProxyClientConnection.processMessage() - clientID:" + this.thisClientId + " unsubscribed from " + message.getItemPath());
            } else {
                Logger.error("ProxyClientConnection.processMessage() - clientID:" + this.thisClientId + " - Unknown message type: " + message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(ProxyMessage message) {
        if (this.clientSocket == null) {
            return;
        }
        boolean relevant = message.getItemPath() == null;
        ArrayList<ItemPath> arrayList = this.subscribedItems;
        synchronized (arrayList) {
            Iterator<ItemPath> iter = this.subscribedItems.iterator();
            while (iter.hasNext() && !relevant) {
                ItemPath thisKey = iter.next();
                if (!thisKey.equals(message.getItemPath())) continue;
                relevant = true;
            }
        }
        if (!relevant) {
            return;
        }
        this.response.println(message);
    }

    @Override
    public void shutdown() {
        if (this.isBusy()) {
            this.closing = true;
            Logger.msg("ProxyClientConnection.shutdown() - clientID: " + this.thisClientId + " closing.");
            this.closeSocket();
        }
    }

    public String toString() {
        if (this.clientSocket == null) {
            return this.thisClientId + ": idle";
        }
        return this.thisClientId + ": " + this.clientSocket.getInetAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeSocket() {
        if (this.clientSocket == null) {
            return;
        }
        try {
            this.request.close();
            this.response.close();
            this.clientSocket.close();
        }
        catch (IOException e) {
            Logger.error("ProxyClientConnection.closeSocket() - clientID: " + this.thisClientId + " - Could not close socket.");
            Logger.error(e);
        }
        ArrayList<ItemPath> arrayList = this.subscribedItems;
        synchronized (arrayList) {
            this.subscribedItems = null;
        }
        this.clientSocket = null;
    }
}

