/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.Agent;
import org.cristalise.kernel.entity.AgentHelper;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

final class JobPusher
extends Thread {
    private final Activity activity;
    private final RolePath myRole;
    private final ItemPath itemPath;

    JobPusher(Activity activity, ItemPath itemPath, RolePath role) {
        this.activity = activity;
        this.itemPath = itemPath;
        this.myRole = role;
    }

    @Override
    public void run() {
        String tName = "Agent job pusher for " + this.itemPath + ":" + this.activity.getPath() + " to role " + this.myRole;
        Thread.currentThread().setName(tName);
        Logger.msg(7, "JobPusher.run() - Started:" + tName);
        try {
            for (AgentPath nextAgent : Gateway.getLookup().getAgents(this.myRole)) {
                Logger.msg(7, "JobPusher.run() - Calculating jobs for agent:" + nextAgent);
                try {
                    JobArrayList jobList = new JobArrayList(this.activity.calculateJobs(nextAgent, this.itemPath, false));
                    if (jobList.list.size() != 0) {
                        String stringJobs = Gateway.getMarshaller().marshall(jobList);
                        Agent thisAgent = AgentHelper.narrow(nextAgent.getIOR());
                        Logger.msg(7, "JobPusher.run() - Calling refreshJobList() with " + jobList.list.size() + " jobs for agent " + nextAgent + " from " + this.activity.getPath());
                        thisAgent.refreshJobList(this.itemPath.getSystemKey(), this.activity.getPath(), stringJobs);
                        continue;
                    }
                    Logger.msg(7, "JobPusher.run() - NO jobs to send to agent " + nextAgent + " from " + this.activity.getPath());
                }
                catch (Exception ex) {
                    Logger.error("JobPusher.run() - Agent " + nextAgent + " of role " + this.myRole + " could not be found to be informed of a change in " + this.itemPath);
                    Logger.error(ex);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            Logger.warning("JobPusher cannot push jobs, it did not find any agents for role:" + this.myRole);
        }
        Logger.msg(7, "JobPusher.run() - FINISHED:" + tName);
    }
}

