/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.XOrSplit;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.utils.Logger;

public class Loop
extends XOrSplit {
    @Override
    public boolean loop() {
        return true;
    }

    @Override
    public void followNext(Next activeNext, AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        WfVertex v = activeNext.getTerminusVertex();
        if (!this.isInPrev(v)) {
            v.run(agent, itemPath, locker);
        } else {
            v.reinit(this.getID());
            v.run(agent, itemPath, locker);
        }
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        Logger.msg(8, "Loop.reinit");
        if (idLoop == this.getID()) {
            return;
        }
        Vertex[] outVertices = this.getOutGraphables();
        for (int j = 0; j < outVertices.length; ++j) {
            if (this.isInPrev(outVertices[j])) continue;
            ((WfVertex)outVertices[j]).reinit(idLoop);
        }
    }

    @Override
    public boolean verify() {
        boolean err = super.verify();
        Vertex[] nexts = this.getOutGraphables();
        Vertex[] anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false);
        int k = 0;
        int l = 0;
        GraphableVertex[] brothers = this.getParent().getChildren();
        for (GraphableVertex brother : brothers) {
            if (!(brother instanceof Loop)) continue;
            ++l;
        }
        for (Vertex next : nexts) {
            for (Vertex anteVertice : anteVertices) {
                if (next.getID() != anteVertice.getID()) continue;
                ++k;
            }
        }
        if (k != 1 && l <= 1) {
            this.mErrors.add("bad number of pointing back nexts");
            return false;
        }
        return err;
    }

    private boolean isInPrev(Vertex vertex) {
        Vertex[] anteVertices;
        int id = vertex.getID();
        for (Vertex anteVertice : anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false)) {
            if (anteVertice.getID() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoop() {
        return true;
    }
}

