/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.AddC2KObject;
import org.cristalise.kernel.lifecycle.instance.predefined.AddDomainPath;
import org.cristalise.kernel.lifecycle.instance.predefined.AddMemberToCollection;
import org.cristalise.kernel.lifecycle.instance.predefined.AddNewCollectionDescription;
import org.cristalise.kernel.lifecycle.instance.predefined.AddNewSlot;
import org.cristalise.kernel.lifecycle.instance.predefined.AssignItemToSlot;
import org.cristalise.kernel.lifecycle.instance.predefined.ClearSlot;
import org.cristalise.kernel.lifecycle.instance.predefined.CreateAgentFromDescription;
import org.cristalise.kernel.lifecycle.instance.predefined.CreateNewCollectionVersion;
import org.cristalise.kernel.lifecycle.instance.predefined.Import;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveC2KObject;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveDomainPath;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveSlotFromCollection;
import org.cristalise.kernel.lifecycle.instance.predefined.ReplaceDomainWorkflow;
import org.cristalise.kernel.lifecycle.instance.predefined.WriteProperty;
import org.cristalise.kernel.lifecycle.instance.predefined.WriteViewpoint;

public abstract class PredefinedStepContainer
extends CompositeActivity {
    protected int num = 0;

    public PredefinedStepContainer() {
        this.setName("predefined");
        this.getProperties().put("Description", "Contains all predefined Steps");
        this.createChildren();
    }

    public void createChildren() {
        this.predInit("AddDomainPath", "Adds a new path to this item in the LDAP domain tree", new AddDomainPath());
        this.predInit("RemoveDomainPath", "Removes an existing path to this item from the LDAP domain tree", new RemoveDomainPath());
        this.predInit("ReplaceDomainWorkflow", "Replaces the domain CA with the supplied one. Used by the GUI to save new Wf layout", new ReplaceDomainWorkflow());
        this.predInit("AddC2KObject", "Adds or overwrites a C2Kernel object for this Item", new AddC2KObject());
        this.predInit("RemoveC2KObject", "Removes the named C2Kernel object from this Item.", new RemoveC2KObject());
        this.predInit("WriteProperty", "Writes a property to the Item", new WriteProperty());
        this.predInit("WriteViewpoint", "Writes a viewpoint to the Item", new WriteViewpoint());
        this.predInit("AddNewCollectionDescription", "Creates a new collection description in this Item", new AddNewCollectionDescription());
        this.predInit("CreateNewCollectionVersion", "Creates a new numbered collection version in this Item from the current one.", new CreateNewCollectionVersion());
        this.predInit("AddNewSlot", "Creates a new slot in the given aggregation, that holds instances of the item description of the given key", new AddNewSlot());
        this.predInit("AssignItemToSlot", "Assigns the referenced item to a pre-existing slot in an aggregation", new AssignItemToSlot());
        this.predInit("ClearSlot", "Clears an aggregation member slot, given a slot no or item uuid", new ClearSlot());
        this.predInit("RemoveSlotFromCollection", "Removed the given slot from the aggregation", new RemoveSlotFromCollection());
        this.predInit("AddMemberToCollection", "Creates a new member slot for the given item in a dependency, and assigns the item", new AddMemberToCollection());
        this.predInit("Import", "Imports an outcome into the Item, with a given schema and viewpoint", new Import());
        this.predInit("CreateAgentFromDescription", "Create a new agent using this item as its description", new CreateAgentFromDescription());
    }

    public void predInit(String alias, String Description, PredefinedStep act) {
        act.setName(alias);
        act.setType(alias);
        act.getProperties().put("Description", Description);
        act.setCentrePoint(new GraphPoint());
        act.setIsPredefined(true);
        this.addChild(act, new GraphPoint(100, 75 * ++this.num));
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public String getErrors() {
        return "predefined";
    }

    @Override
    public boolean getActive() {
        return true;
    }
}

