/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.item;

import java.io.IOException;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.CorbaServer;
import org.cristalise.kernel.entity.TraceableEntity;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class CreateItemFromDescription
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        String[] input = CreateItemFromDescription.getDataList(requestData);
        String newName = input[0];
        String domPath = input[1];
        String descVer = input.length > 2 ? input[2] : "last";
        Logger.msg(1, "CreateItemFromDescription - Starting.");
        DomainPath context = new DomainPath(new DomainPath(domPath), newName);
        if (context.exists()) {
            throw new ObjectAlreadyExistsException("The path " + context + " exists already.");
        }
        Logger.msg(6, "CreateItemFromDescription - Requesting new item path");
        ItemPath newItemPath = new ItemPath();
        Logger.msg(3, "CreateItemFromDescription - Creating Item");
        CorbaServer factory = Gateway.getCorbaServer();
        if (factory == null) {
            throw new CannotManageException("This process cannot create new Items");
        }
        TraceableEntity newItem = factory.createItem(newItemPath);
        Gateway.getLookupManager().add(newItemPath);
        Logger.msg(3, "CreateItemFromDescription - Initializing Item");
        try {
            PropertyArrayList initProps = input.length > 3 ? this.unmarshallInitProperties(input[3]) : new PropertyArrayList();
            PropertyArrayList newProps = this.instantiateProperties(itemPath, descVer, initProps, newName, agent, locker);
            CollectionArrayList newColls = this.instantiateCollections(itemPath, descVer, newProps, locker);
            CompositeActivity newWorkflow = this.instantiateWorkflow(itemPath, descVer, locker);
            newItem.initialise(agent.getSystemKey(), Gateway.getMarshaller().marshall(newProps), Gateway.getMarshaller().marshall(newWorkflow), Gateway.getMarshaller().marshall(newColls));
        }
        catch (IOException | AccessRightsException | MappingException | MarshalException | ValidationException e) {
            Logger.error((Throwable)e);
            Gateway.getLookupManager().delete(newItemPath);
            throw new InvalidDataException("CreateItemFromDescription: Problem initializing new Item. See log: " + ((Throwable)e).getMessage());
        }
        catch (Exception e) {
            Logger.error(e);
            Gateway.getLookupManager().delete(newItemPath);
            throw e;
        }
        Logger.msg(3, "CreateItemFromDescription - Creating " + context);
        context.setItemPath(newItemPath);
        Gateway.getLookupManager().add(context);
        return requestData;
    }

    protected PropertyArrayList unmarshallInitProperties(String initPropString) throws InvalidDataException {
        try {
            return (PropertyArrayList)Gateway.getMarshaller().unmarshall(initPropString);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Initial property parameter was not a marshalled PropertyArrayList: " + initPropString);
        }
    }

    protected PropertyArrayList instantiateProperties(ItemPath itemPath, String descVer, PropertyArrayList initProps, String newName, AgentPath agent, Object locker) throws ObjectNotFoundException, InvalidDataException {
        PropertyDescriptionList pdList = PropertyUtility.getPropertyDescriptionOutcome(itemPath, descVer, locker);
        PropertyArrayList props = pdList.instantiate(initProps);
        boolean foundName = false;
        for (Property prop : props.list) {
            if (!prop.getName().equals(BuiltInItemProperties.NAME.toString())) continue;
            foundName = true;
            prop.setValue(newName);
            break;
        }
        if (!foundName) {
            props.list.add(new Property(BuiltInItemProperties.NAME, newName, true));
        }
        props.list.add(new Property(BuiltInItemProperties.CREATOR, agent.getAgentName(), false));
        return props;
    }

    protected CompositeActivity instantiateWorkflow(ItemPath itemPath, String descVer, Object locker) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        Collection thisCol = (Collection)Gateway.getStorage().get(itemPath, "Collection/" + (Object)((Object)BuiltInCollections.WORKFLOW) + "/" + descVer, locker);
        CollectionMember wfMember = (CollectionMember)thisCol.getMembers().list.get(0);
        String wfDefName = wfMember.resolveItem().getName();
        Object wfVerObj = wfMember.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        if (wfVerObj == null || String.valueOf(wfVerObj).length() == 0) {
            throw new InvalidDataException("Workflow version number not set");
        }
        try {
            Integer wfDefVer = Integer.parseInt(wfVerObj.toString());
            if (wfDefName == null) {
                throw new InvalidDataException("No workflow given or defined");
            }
            CompositeActivityDef wfDef = (CompositeActivityDef)LocalObjectLoader.getActDef(wfDefName, wfDefVer);
            return (CompositeActivity)wfDef.instantiate();
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid workflow version number: " + wfVerObj.toString());
        }
        catch (ClassCastException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Activity def '" + wfDefName + "' was not Composite");
        }
    }

    protected CollectionArrayList instantiateCollections(ItemPath itemPath, String descVer, PropertyArrayList newProps, Object locker) throws ObjectNotFoundException, PersistencyException, InvalidDataException {
        String[] collNames;
        CollectionArrayList colls = new CollectionArrayList();
        for (String collName : collNames = Gateway.getStorage().getClusterContents(itemPath, "Collection")) {
            Collection thisCol = (Collection)Gateway.getStorage().get(itemPath, "Collection/" + collName + "/" + descVer, locker);
            if (thisCol instanceof CollectionDescription) {
                Logger.msg(5, "CreateItemFromDescription - Instantiating CollectionDescription:" + collName);
                CollectionDescription thisDesc = (CollectionDescription)((Object)thisCol);
                colls.put(thisDesc.newInstance());
                continue;
            }
            if (thisCol instanceof Dependency) {
                Logger.msg(5, "CreateItemFromDescription - Instantiating Dependency:" + collName);
                ((Dependency)thisCol).addToItemProperties(newProps);
                continue;
            }
            Logger.warning("CreateItemFromDescription - CANNOT instantiate collection:" + collName + " class:" + thisCol.getClass().getName());
        }
        return colls;
    }
}

