/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class CreateNewRole
extends PredefinedStep {
    public CreateNewRole() {
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "Role");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        ImportRole newRole;
        try {
            newRole = (ImportRole)Gateway.getMarshaller().unmarshall(requestData);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("CreateNewRole: Couldn't unmarshall new Role: " + requestData);
        }
        if (Gateway.getLookup().getRolePath(newRole.getName()).exists()) {
            throw new ObjectAlreadyExistsException("Role '" + newRole.getName() + "' already exists.");
        }
        newRole.create(agent, true);
        return requestData;
    }
}

