/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.omg.CORBA.Object;

public class ItemPath
extends Path {
    protected UUID mUUID;
    protected String mIOR;

    public ItemPath() {
        this.setSysKey(UUID.randomUUID());
    }

    public ItemPath(UUID uuid, String ior) {
        this.setSysKey(uuid);
        this.setIORString(ior);
    }

    public ItemPath(UUID uuid) {
        this.setSysKey(uuid);
    }

    public ItemPath(SystemKey syskey) {
        this.setSysKey(syskey);
    }

    public ItemPath(String[] path) throws InvalidItemPathException {
        super(path);
        this.getSysKeyFromPath();
    }

    public ItemPath(String path) throws InvalidItemPathException {
        super(path);
        if (path == null) {
            throw new InvalidItemPathException("Path cannot be null");
        }
        this.getSysKeyFromPath();
    }

    @Override
    public void setPath(String[] path) {
        super.setPath(path);
        this.mUUID = null;
    }

    @Override
    public void setPath(String path) {
        super.setPath(path);
        this.mUUID = null;
    }

    @Override
    public void setPath(Path path) {
        super.setPath(path);
        this.mUUID = null;
    }

    private void getSysKeyFromPath() throws InvalidItemPathException {
        if (this.mPath.length == 1) {
            try {
                this.setSysKey(UUID.fromString(this.mPath[0]));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidItemPathException(this.mPath[0] + " is not a valid UUID");
            }
        } else {
            throw new InvalidItemPathException("Not a valid item path: " + Arrays.toString(this.mPath));
        }
    }

    @Override
    public String getRoot() {
        return "entity";
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        return this;
    }

    @Override
    public Object getIOR() {
        if (this.mIOR == null) {
            try {
                this.mIOR = Gateway.getLookup().getIOR(this);
            }
            catch (ObjectNotFoundException ex) {
                Logger.warning(ex.getMessage());
                return null;
            }
        }
        return Gateway.getORB().string_to_object(this.mIOR);
    }

    @Override
    public void setIOR(Object IOR) {
        this.mIOR = Gateway.getORB().object_to_string(IOR);
    }

    public String getIORString() {
        return this.mIOR;
    }

    public void setIORString(String ior) {
        this.mIOR = ior;
    }

    public byte[] getOID() {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(this.mUUID.getMostSignificantBits());
        bb.putLong(this.mUUID.getLeastSignificantBits());
        return bb.array();
    }

    protected void setSysKey(UUID uuid) {
        this.mUUID = uuid;
        this.setPathFromUUID(this.mUUID.toString());
    }

    protected void setSysKey(SystemKey sysKey) {
        this.mUUID = new UUID(sysKey.msb, sysKey.lsb);
        this.setPathFromUUID(this.mUUID.toString());
    }

    private void setPathFromUUID(String uuid) {
        this.mPath = new String[1];
        this.mPath[0] = uuid;
    }

    @Override
    public SystemKey getSystemKey() {
        return new SystemKey(this.mUUID.getMostSignificantBits(), this.mUUID.getLeastSignificantBits());
    }

    @Override
    public UUID getUUID() {
        return this.mUUID;
    }
}

