/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.persistency.outcome.OutcomeValidator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Outcome
implements C2KLocalObject {
    private static final int NONE = -1;
    Integer mID;
    Schema mSchema;
    Document mDOM;
    static DocumentBuilder parser;
    static XPath xpath;

    public Outcome(String xml) throws InvalidDataException {
        this(-1, xml, null);
    }

    public Outcome(String xml, Schema schema) throws InvalidDataException {
        this(-1, xml, schema);
    }

    public Outcome(int id, String xml, Schema schema) throws InvalidDataException {
        this(id, (Document)null, schema);
        try {
            this.mDOM = Outcome.parse(xml);
        }
        catch (IOException | SAXException ex) {
            Logger.error("INVALID XML - schema:" + this.mSchema.getName() + "\n" + xml);
            Logger.error(ex);
            throw new InvalidDataException("XML not valid for schema:" + this.mSchema + " error:" + ex.getMessage());
        }
    }

    public Outcome(int id, Document dom, Schema schema) {
        this.mID = id;
        this.mDOM = dom;
        this.mSchema = schema;
    }

    public Outcome(String path, String xml) throws PersistencyException, InvalidDataException {
        this.setMetaDataFromPath(path);
        try {
            this.mDOM = Outcome.parse(xml);
        }
        catch (IOException | SAXException ex) {
            Logger.error(ex);
            throw new InvalidDataException("XML not valid: " + ex.getMessage());
        }
    }

    public Outcome(String path, Document data) throws PersistencyException, InvalidDataException {
        this.setMetaDataFromPath(path);
        this.mDOM = data;
    }

    protected void setMetaDataFromPath(String path) throws PersistencyException, InvalidDataException {
        StringTokenizer tok = new StringTokenizer(path, "/");
        if (tok.countTokens() != 3 && !tok.nextToken().equals("Outcome")) {
            throw new PersistencyException("Outcome() - Outcome path must have three components:" + path);
        }
        String schemaName = tok.nextToken();
        String verString = tok.nextToken();
        String objId = tok.nextToken();
        try {
            Integer schemaVersion = Integer.valueOf(verString);
            this.mSchema = LocalObjectLoader.getSchema(schemaName, schemaVersion);
            this.mID = Integer.valueOf(objId);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Outcome() - Version or EventID was an invalid number version:" + verString + " eventID:" + objId);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)((Object)e));
            throw new InvalidDataException("Outcome() - problem loading schema:" + schemaName + " version:" + verString);
        }
    }

    public String validate() throws InvalidDataException {
        if (this.mSchema == null) {
            this.mDOM.normalize();
        }
        OutcomeValidator validator = OutcomeValidator.getValidator(this.mSchema);
        return validator.validate(this.mDOM);
    }

    public void validateAndCheck() throws InvalidDataException {
        String error = this.validate();
        if (StringUtils.isNotBlank((CharSequence)error)) {
            Logger.error("Outcome.validateAndCheck() - Outcome not valid: " + error);
            Logger.msg("XML: \n" + this.getData());
            Logger.msg("XSD: \n" + this.getSchema().getXSD());
            throw new InvalidDataException(error);
        }
    }

    @Override
    public void setName(String name) {
        try {
            this.mID = Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            Logger.error("Invalid id set on Outcome:" + name);
        }
    }

    @Override
    public String getName() {
        return this.mID.toString();
    }

    public void setData(String xml) throws SAXException, IOException {
        this.mDOM = Outcome.parse(xml);
    }

    public String getFieldByXPath(String xpath) throws XPathExpressionException, InvalidDataException {
        Node field = this.getNodeByXPath(xpath);
        if (field == null) {
            throw new InvalidDataException("Outcome '" + this.getSchemaType() + "' cannot resolve xpath:" + xpath);
        }
        if (field.getNodeType() == 3 || field.getNodeType() == 4 || field.getNodeType() == 2) {
            return field.getNodeValue();
        }
        if (field.getNodeType() == 1) {
            NodeList fieldChildren = field.getChildNodes();
            if (fieldChildren.getLength() == 0) {
                throw new InvalidDataException("No child/text node for element '" + field.getNodeName() + "'");
            }
            if (fieldChildren.getLength() == 1) {
                Node child = fieldChildren.item(0);
                if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                    return child.getNodeValue();
                }
                throw new InvalidDataException("Element '" + field.getNodeName() + "' can't get data from child node of type '" + child.getNodeName() + "'");
            }
            throw new InvalidDataException("Element " + xpath + " has too many children");
        }
        throw new InvalidDataException("Don't know what to do with node '" + field.getNodeName() + "'");
    }

    public void setFieldByXPath(String xpath, String data) throws XPathExpressionException, InvalidDataException {
        this.setFieldByXPath(xpath, data, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFieldByXPath(String xpath, String data, boolean remove) throws XPathExpressionException, InvalidDataException {
        Node field;
        if (StringUtils.isBlank((CharSequence)xpath)) {
            throw new InvalidDataException("Xpath is null or empty string");
        }
        if (data == null && remove) {
            Logger.msg(7, "Outcome.setFieldByXPath() - removing field xpath");
            this.removeNodeByXPath(xpath);
            return;
        }
        if (data == null) {
            data = "";
        }
        if ((field = this.getNodeByXPath(xpath)) == null) {
            Logger.error(this.getData());
            throw new InvalidDataException("Xpath '" + xpath + "' is invalid");
        }
        if (field.getNodeType() == 1) {
            NodeList fieldChildren = field.getChildNodes();
            if (fieldChildren.getLength() == 0) {
                field.appendChild(this.mDOM.createTextNode(data));
                return;
            } else {
                if (fieldChildren.getLength() != 1) throw new InvalidDataException("Element " + xpath + " must have zero or one children node");
                Node child = fieldChildren.item(0);
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        child.setNodeValue(data);
                        return;
                    }
                    default: {
                        throw new InvalidDataException("Can't set child node of type " + child.getNodeName());
                    }
                }
            }
        } else {
            if (field.getNodeType() != 2) throw new InvalidDataException("Don't know what to do with node " + field.getNodeName());
            field.setNodeValue(data);
        }
    }

    public Node appendXmlFragment(String xpath, String xmlFragment) throws InvalidDataException {
        try {
            Node parentNode = this.getNodeByXPath(xpath);
            Element newNode = Outcome.parse(xmlFragment).getDocumentElement();
            return parentNode.appendChild(this.mDOM.importNode(newNode, true));
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public String getData() {
        try {
            return Outcome.serialize(this.mDOM, false);
        }
        catch (InvalidDataException e) {
            Logger.error((Throwable)((Object)e));
            return null;
        }
    }

    @Deprecated
    public String getSchemaType() {
        if (this.mSchema == null) {
            throw new IllegalArgumentException("Outcome must have valid Schema");
        }
        return this.mSchema.getName();
    }

    @Deprecated
    public int getSchemaVersion() {
        if (this.mSchema == null) {
            throw new IllegalArgumentException("Outcome must have valid Schema");
        }
        return this.mSchema.getVersion();
    }

    @Override
    public String getClusterType() {
        return "Outcome";
    }

    @Override
    public String getClusterPath() {
        if (this.mID == null || this.mID == -1 || this.mSchema == null) {
            throw new IllegalArgumentException("Outcome must have valid ID and Schema");
        }
        return this.getClusterType() + "/" + this.mSchema.getName() + "/" + this.mSchema.getVersion() + "/" + this.mID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(String xml) throws SAXException, IOException {
        DocumentBuilder documentBuilder = parser;
        synchronized (documentBuilder) {
            if (xml != null) {
                return parser.parse(new InputSource(new StringReader(xml)));
            }
            return parser.newDocument();
        }
    }

    public String getAttribute(String name) {
        String value = this.mDOM.getDocumentElement().getAttribute(name);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return null;
    }

    public String getAttributeOfField(String field, String attribute) {
        NodeList elements = this.mDOM.getDocumentElement().getElementsByTagName(field);
        if (elements.getLength() == 1 && elements.item(0).hasChildNodes() && elements.item(0).getFirstChild() instanceof Text) {
            String value = ((Element)elements.item(0)).getAttribute(attribute);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            return null;
        }
        return null;
    }

    public String getField(String name) {
        NodeList elements = this.mDOM.getDocumentElement().getElementsByTagName(name);
        if (elements.getLength() == 1 && elements.item(0).hasChildNodes() && elements.item(0).getFirstChild() instanceof Text) {
            return ((Text)elements.item(0).getFirstChild()).getData();
        }
        return null;
    }

    public NodeList getNodesByXPath(String xpathExpr) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(xpathExpr);
        return (NodeList)expr.evaluate(this.mDOM, XPathConstants.NODESET);
    }

    public Node getNodeByXPath(String xpathExpr) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(xpathExpr);
        return (Node)expr.evaluate(this.mDOM, XPathConstants.NODE);
    }

    public Node removeNodeByXPath(String xpathExpr) throws XPathExpressionException, InvalidDataException {
        if (StringUtils.isBlank((CharSequence)xpathExpr)) {
            throw new InvalidDataException("Xpath is null or empty string");
        }
        Node nodeToTemove = this.getNodeByXPath(xpathExpr);
        if (nodeToTemove == null) {
            Logger.error("Xpath '" + xpathExpr + "' is invalid\n" + this.getData());
            throw new InvalidDataException("Xpath '" + xpathExpr + "' is invalid");
        }
        return nodeToTemove.getParentNode().removeChild(nodeToTemove);
    }

    public static String serialize(Document doc, boolean prettyPrint) throws InvalidDataException {
        Transformer transformer;
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            Logger.error(ex);
            return "";
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", prettyPrint ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter out = new StringWriter();
        try {
            transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
        return ((Object)out).toString();
    }

    public Integer getID() {
        return this.mID;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public Document getDOM() {
        return this.mDOM;
    }

    public void setID(Integer mID) {
        this.mID = mID;
    }

    public void setSchema(Schema mSchema) {
        this.mSchema = mSchema;
    }

    public void setDOM(Document mDOM) {
        this.mDOM = mDOM;
    }

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(false);
        try {
            parser = dbf.newDocumentBuilder();
            Logger.msg(7, "Outcome static class init: " + parser.getClass().getName());
        }
        catch (ParserConfigurationException e) {
            Logger.error(e);
            Logger.die("Cannot function without XML parser");
        }
        XPathFactory xPathFactory = XPathFactory.newInstance();
        xpath = xPathFactory.newXPath();
    }
}

