/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;

public class Viewpoint
implements C2KLocalObject {
    public static final int NONE = -1;
    ItemPath itemPath;
    String schemaName;
    String name;
    int schemaVersion;
    int eventId;

    public Viewpoint() {
        this.eventId = -1;
        this.itemPath = null;
        this.schemaVersion = -1;
        this.schemaName = null;
        this.name = null;
    }

    public Viewpoint(ItemPath itemPath, String schemaName, String name, int schemaVersion, int eventId) {
        this.setName(name);
        this.itemPath = itemPath;
        this.schemaName = schemaName;
        this.schemaVersion = schemaVersion;
        this.eventId = eventId;
    }

    public Viewpoint(ItemPath itemPath, Schema schema, String name, int eventId) {
        this.setName(name);
        this.itemPath = itemPath;
        this.schemaName = schema.getName();
        this.schemaVersion = schema.getVersion();
        this.eventId = eventId;
    }

    public Outcome getOutcome() throws ObjectNotFoundException, PersistencyException {
        return this.getOutcome(null);
    }

    public Outcome getOutcome(Object locker) throws ObjectNotFoundException, PersistencyException {
        if (this.eventId == -1) {
            throw new ObjectNotFoundException("No last eventId defined for path:" + this.getClusterPath());
        }
        return (Outcome)Gateway.getStorage().get(this.itemPath, "Outcome/" + this.schemaName + "/" + this.schemaVersion + "/" + this.eventId, locker);
    }

    @Override
    public void setName(String n) {
        if (!StringUtils.isAlphanumeric((CharSequence)n)) {
            throw new IllegalArgumentException("Viewpoint name='" + n + "' must be alphanumeric only");
        }
        this.name = n;
    }

    @Override
    public String getClusterType() {
        return "ViewPoint";
    }

    @Override
    public String getClusterPath() {
        return this.getClusterType() + "/" + this.schemaName + "/" + this.name;
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public Event getEvent() throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (this.eventId == -1) {
            throw new InvalidDataException("No last eventId defined for path:" + this.getClusterPath());
        }
        return (Event)Gateway.getStorage().get(this.itemPath, "AuditTrail/" + this.eventId, null);
    }

    public String toString() {
        return this.name;
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public int getEventId() {
        return this.eventId;
    }

    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }
}

